/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.core;

import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.ICacheSpec;
import io.github.xanthic.cache.core.CacheApiSpec;
import io.github.xanthic.cache.core.delegate.EmptyCache;
import java.time.Duration;
import java.util.function.Consumer;

public final class CacheApi {
    private CacheApi() {
    }

    public static <K, V> Cache<K, V> create(Consumer<CacheApiSpec<K, V>> spec) {
        CacheApiSpec<K, V> finalSpec = CacheApiSpec.process(spec);
        if (CacheApi.isPermanentlyEmpty(finalSpec)) {
            return EmptyCache.get();
        }
        return finalSpec.provider().build(finalSpec);
    }

    private static boolean isPermanentlyEmpty(ICacheSpec<?, ?> spec) {
        Long maxSize = spec.maxSize();
        Duration expiryTime = spec.expiryTime();
        return maxSize != null && maxSize == 0L || expiryTime != null && expiryTime.isZero();
    }
}

