/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.core.delegate;

import io.github.xanthic.cache.api.Cache;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericMapCacheDelegate<K, V>
implements Cache<K, V> {
    private final Map<K, V> map;

    @Override
    public V get(@NotNull K key) {
        return this.map.get(key);
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        return this.map.put(key, value);
    }

    @Override
    @Nullable
    public V compute(@NotNull K key, @NotNull BiFunction<? super K, ? super V, ? extends V> computeFunc) {
        return this.map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)computeFunc);
    }

    @Override
    public V computeIfAbsent(@NotNull K key, @NotNull Function<K, V> computeFunc) {
        return this.map.computeIfAbsent(key, computeFunc);
    }

    @Override
    public V computeIfPresent(@NotNull K key, @NotNull BiFunction<? super K, ? super V, ? extends V> computeFunc) {
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)computeFunc);
    }

    @Override
    public V remove(@NotNull K key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public V merge(@NotNull K key, @NotNull V value, @NotNull BiFunction<V, V, V> mergeFunc) {
        return this.map.merge(key, value, mergeFunc);
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V value) {
        return this.map.replace(key, value) != null;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.map.putAll(map);
    }

    @Override
    public void forEach(@NotNull BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    @Generated
    public GenericMapCacheDelegate(Map<K, V> map) {
        this.map = map;
    }

    @Generated
    public Map<K, V> getMap() {
        return this.map;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericMapCacheDelegate)) {
            return false;
        }
        GenericMapCacheDelegate other = (GenericMapCacheDelegate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<K, V> this$map = this.getMap();
        Map<K, V> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GenericMapCacheDelegate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<K, V> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GenericMapCacheDelegate(map=" + this.getMap() + ")";
    }
}

