/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConfiguration
extends AbstractConfiguration {
    private final DataSource datasource;
    private final String table;
    private final String nameColumn;
    private final String keyColumn;
    private final String valueColumn;
    private final String name;
    private final boolean doCommits;

    public DatabaseConfiguration(DataSource datasource, String table, String nameColumn, String keyColumn, String valueColumn, String name) {
        this(datasource, table, nameColumn, keyColumn, valueColumn, name, false);
    }

    public DatabaseConfiguration(DataSource datasource, String table, String nameColumn, String keyColumn, String valueColumn, String name, boolean commits) {
        this.datasource = datasource;
        this.table = table;
        this.nameColumn = nameColumn;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
        this.name = name;
        this.doCommits = commits;
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    public DatabaseConfiguration(DataSource datasource, String table, String keyColumn, String valueColumn) {
        this(datasource, table, null, keyColumn, valueColumn, null);
    }

    public DatabaseConfiguration(DataSource datasource, String table, String keyColumn, String valueColumn, boolean commits) {
        this(datasource, table, null, keyColumn, valueColumn, null, commits);
    }

    public boolean isDoCommits() {
        return this.doCommits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String key) {
        ArrayList<Object> result = null;
        StringBuilder query = new StringBuilder("SELECT * FROM ");
        query.append(this.table).append(" WHERE ");
        query.append(this.keyColumn).append("=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            pstmt.setString(1, key);
            if (this.nameColumn != null) {
                pstmt.setString(2, this.name);
            }
            rs = pstmt.executeQuery();
            ArrayList<Object> results = new ArrayList<Object>();
            while (rs.next()) {
                Object value = rs.getObject(this.valueColumn);
                if (this.isDelimiterParsingDisabled()) {
                    results.add(value);
                    continue;
                }
                Iterator<?> it = PropertyConverter.toIterator(value, this.getListDelimiter());
                while (it.hasNext()) {
                    results.add(it.next());
                }
            }
            if (!results.isEmpty()) {
                result = results.size() > 1 ? results : results.get(0);
            }
            this.close(conn, pstmt, rs);
        }
        catch (SQLException e) {
            try {
                this.fireError(5, key, null, e);
                this.close(conn, pstmt, rs);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt, rs);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPropertyDirect(String key, Object obj) {
        StringBuilder query = new StringBuilder("INSERT INTO " + this.table);
        if (this.nameColumn != null) {
            query.append(" (" + this.nameColumn + ", " + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?, ?)");
        } else {
            query.append(" (" + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?)");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            int index = 1;
            if (this.nameColumn != null) {
                pstmt.setString(index++, this.name);
            }
            pstmt.setString(index++, key);
            pstmt.setString(index++, String.valueOf(obj));
            pstmt.executeUpdate();
            this.commitIfRequired(conn);
            this.close(conn, pstmt, null);
        }
        catch (SQLException e) {
            try {
                this.fireError(1, key, obj, e);
                this.close(conn, pstmt, null);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProperty(String key, Object value) {
        boolean parsingFlag = this.isDelimiterParsingDisabled();
        try {
            if (value instanceof String) {
                this.setDelimiterParsingDisabled(true);
            }
            super.addProperty(key, value);
        }
        finally {
            this.setDelimiterParsingDisabled(parsingFlag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean empty = true;
        StringBuilder query = new StringBuilder("SELECT count(*) FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            if (this.nameColumn != null) {
                pstmt.setString(1, this.name);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                empty = rs.getInt(1) == 0;
            }
            this.close(conn, pstmt, rs);
        }
        catch (SQLException e) {
            try {
                this.fireError(5, null, null, e);
                this.close(conn, pstmt, rs);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt, rs);
                throw throwable;
            }
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        boolean found = false;
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            pstmt.setString(1, key);
            if (this.nameColumn != null) {
                pstmt.setString(2, this.name);
            }
            rs = pstmt.executeQuery();
            found = rs.next();
            this.close(conn, pstmt, rs);
        }
        catch (SQLException e) {
            try {
                this.fireError(5, key, null, e);
                this.close(conn, pstmt, rs);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt, rs);
                throw throwable;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearPropertyDirect(String key) {
        StringBuilder query = new StringBuilder("DELETE FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            pstmt.setString(1, key);
            if (this.nameColumn != null) {
                pstmt.setString(2, this.name);
            }
            pstmt.executeUpdate();
            this.commitIfRequired(conn);
            this.close(conn, pstmt, null);
        }
        catch (SQLException e) {
            try {
                this.fireError(2, key, null, e);
                this.close(conn, pstmt, null);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        StringBuilder query = new StringBuilder("DELETE FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            if (this.nameColumn != null) {
                pstmt.setString(1, this.name);
            }
            pstmt.executeUpdate();
            this.commitIfRequired(conn);
            this.close(conn, pstmt, null);
        }
        catch (SQLException e) {
            try {
                this.fireError(4, null, null, e);
                this.close(conn, pstmt, null);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt, null);
                throw throwable;
            }
        }
        this.fireEvent(4, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getKeys() {
        ArrayList<String> keys2 = new ArrayList<String>();
        StringBuilder query = new StringBuilder("SELECT DISTINCT " + this.keyColumn + " FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement(query.toString());
            if (this.nameColumn != null) {
                pstmt.setString(1, this.name);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                keys2.add(rs.getString(1));
            }
            this.close(conn, pstmt, rs);
        }
        catch (SQLException e) {
            try {
                this.fireError(5, null, null, e);
                this.close(conn, pstmt, rs);
            }
            catch (Throwable throwable) {
                this.close(conn, pstmt, rs);
                throw throwable;
            }
        }
        return keys2.iterator();
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    @Deprecated
    protected Connection getConnection() throws SQLException {
        return this.getDatasource().getConnection();
    }

    private void close(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().error("An error occurred on closing the result set", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().error("An error occured on closing the statement", e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().error("An error occured on closing the connection", e);
        }
    }

    private void commitIfRequired(Connection conn) throws SQLException {
        if (this.isDoCommits()) {
            conn.commit();
        }
    }
}

