/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ViewNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalINIConfiguration
extends AbstractHierarchicalFileConfiguration {
    protected static final String COMMENT_CHARS = "#;";
    protected static final String SEPARATOR_CHARS = "=:";
    private static final long serialVersionUID = 2548006161386850670L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String QUOTE_CHARACTERS = "\"'";
    private static final String LINE_CONT = "\\";

    public HierarchicalINIConfiguration() {
    }

    public HierarchicalINIConfiguration(String filename) throws ConfigurationException {
        super(filename);
    }

    public HierarchicalINIConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public HierarchicalINIConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        PrintWriter out = new PrintWriter(writer);
        for (String section : this.getSections()) {
            SubnodeConfiguration subset;
            if (section != null) {
                out.print("[");
                out.print(section);
                out.print("]");
                out.println();
                subset = this.createSubnodeConfiguration(this.getSectionNode(section));
            } else {
                subset = this.getSection(null);
            }
            Iterator<String> keys2 = subset.getKeys();
            while (keys2.hasNext()) {
                String key = keys2.next();
                Object value2 = subset.getProperty(key);
                if (value2 instanceof Collection) {
                    for (Object value2 : (Collection)value2) {
                        out.print(key);
                        out.print(" = ");
                        out.print(this.formatValue(value2.toString()));
                        out.println();
                    }
                    continue;
                }
                out.print(key);
                out.print(" = ");
                out.print(this.formatValue(value2.toString()));
                out.println();
            }
            out.println();
        }
        out.flush();
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            ConfigurationNode sectionNode = this.getRootNode();
            String line = bufferedReader.readLine();
            while (line != null) {
                if (!this.isCommentLine(line = line.trim())) {
                    if (this.isSectionLine(line)) {
                        String section = line.substring(1, line.length() - 1);
                        sectionNode = this.getSectionNode(section);
                    } else {
                        String key = "";
                        String value = "";
                        int index = HierarchicalINIConfiguration.findSeparator(line);
                        if (index >= 0) {
                            key = line.substring(0, index);
                            value = HierarchicalINIConfiguration.parseValue(line.substring(index + 1), bufferedReader);
                        } else {
                            key = line;
                        }
                        key = key.trim();
                        if (key.length() < 1) {
                            key = " ";
                        }
                        this.createValueNodes(sectionNode, key, value);
                    }
                }
                line = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to load the configuration", e);
        }
    }

    private void createValueNodes(ConfigurationNode sectionNode, String key, String value) {
        Collection<String> values2 = this.isDelimiterParsingDisabled() ? Collections.singleton(value) : PropertyConverter.split(value, this.getListDelimiter(), false);
        for (String v : values2) {
            HierarchicalConfiguration.Node node = this.createNode(key);
            node.setValue(v);
            sectionNode.addChild(node);
        }
    }

    private static String parseValue(String val, BufferedReader reader) throws IOException {
        boolean lineContinues;
        StringBuilder propertyValue = new StringBuilder();
        String value = val.trim();
        do {
            int i;
            boolean quoted = value.startsWith("\"") || value.startsWith("'");
            boolean stop = false;
            boolean escape = false;
            char quote = quoted ? value.charAt(0) : (char)'\u0000';
            StringBuilder result = new StringBuilder();
            char lastChar = '\u0000';
            for (i = quoted ? 1 : 0; i < value.length() && !stop; ++i) {
                char c = value.charAt(i);
                if (quoted) {
                    if ('\\' == c && !escape) {
                        escape = true;
                    } else if (!escape && quote == c) {
                        stop = true;
                    } else if (escape && quote == c) {
                        escape = false;
                        result.append(c);
                    } else {
                        if (escape) {
                            escape = false;
                            result.append('\\');
                        }
                        result.append(c);
                    }
                } else if (HierarchicalINIConfiguration.isCommentChar(c) && Character.isWhitespace(lastChar)) {
                    stop = true;
                } else {
                    result.append(c);
                }
                lastChar = c;
            }
            String v = result.toString();
            if (!quoted) {
                lineContinues = HierarchicalINIConfiguration.lineContinues(v = v.trim());
                if (lineContinues) {
                    v = v.substring(0, v.length() - 1).trim();
                }
            } else {
                lineContinues = HierarchicalINIConfiguration.lineContinues(value, i);
            }
            propertyValue.append(v);
            if (!lineContinues) continue;
            propertyValue.append(LINE_SEPARATOR);
            value = reader.readLine();
        } while (lineContinues && value != null);
        return propertyValue.toString();
    }

    private static boolean lineContinues(String line) {
        String s2 = line.trim();
        return s2.equals(LINE_CONT) || s2.length() > 2 && s2.endsWith(LINE_CONT) && Character.isWhitespace(s2.charAt(s2.length() - 2));
    }

    private static boolean lineContinues(String line, int pos) {
        String s2;
        if (pos >= line.length()) {
            s2 = line;
        } else {
            int end;
            for (end = pos; end < line.length() && !HierarchicalINIConfiguration.isCommentChar(line.charAt(end)); ++end) {
            }
            s2 = line.substring(pos, end);
        }
        return HierarchicalINIConfiguration.lineContinues(s2);
    }

    private static boolean isCommentChar(char c) {
        return COMMENT_CHARS.indexOf(c) >= 0;
    }

    private static int findSeparator(String line) {
        int index = HierarchicalINIConfiguration.findSeparatorBeforeQuote(line, HierarchicalINIConfiguration.findFirstOccurrence(line, QUOTE_CHARACTERS));
        if (index < 0) {
            index = HierarchicalINIConfiguration.findFirstOccurrence(line, SEPARATOR_CHARS);
        }
        return index;
    }

    private static int findFirstOccurrence(String line, String separators) {
        int index = -1;
        for (int i = 0; i < separators.length(); ++i) {
            char sep = separators.charAt(i);
            int pos = line.indexOf(sep);
            if (pos < 0 || index >= 0 && pos >= index) continue;
            index = pos;
        }
        return index;
    }

    private static int findSeparatorBeforeQuote(String line, int quoteIndex) {
        int index;
        for (index = quoteIndex - 1; index >= 0 && Character.isWhitespace(line.charAt(index)); --index) {
        }
        if (index >= 0 && SEPARATOR_CHARS.indexOf(line.charAt(index)) < 0) {
            index = -1;
        }
        return index;
    }

    private String formatValue(String value) {
        boolean quoted = false;
        for (int i = 0; i < COMMENT_CHARS.length() && !quoted; ++i) {
            char c = COMMENT_CHARS.charAt(i);
            if (value.indexOf(c) == -1) continue;
            quoted = true;
        }
        if (quoted) {
            return '\"' + value.replaceAll("\"", "\\\\\\\"") + '\"';
        }
        return value;
    }

    protected boolean isCommentLine(String line) {
        if (line == null) {
            return false;
        }
        return line.length() < 1 || COMMENT_CHARS.indexOf(line.charAt(0)) >= 0;
    }

    protected boolean isSectionLine(String line) {
        if (line == null) {
            return false;
        }
        return line.startsWith("[") && line.endsWith("]");
    }

    public Set<String> getSections() {
        LinkedHashSet<String> sections = new LinkedHashSet<String>();
        boolean globalSection = false;
        boolean inSection = false;
        for (ConfigurationNode node : this.getRootNode().getChildren()) {
            if (HierarchicalINIConfiguration.isSectionNode(node)) {
                inSection = true;
                sections.add(node.getName());
                continue;
            }
            if (inSection || globalSection) continue;
            globalSection = true;
            sections.add(null);
        }
        return sections;
    }

    public SubnodeConfiguration getSection(String name) {
        if (name == null) {
            return this.getGlobalSection();
        }
        try {
            return this.configurationAt(name);
        }
        catch (IllegalArgumentException iex) {
            return new SubnodeConfiguration(this, this.getSectionNode(name));
        }
    }

    private ConfigurationNode getSectionNode(String sectionName) {
        List<ConfigurationNode> nodes = this.getRootNode().getChildren(sectionName);
        if (!nodes.isEmpty()) {
            return nodes.get(0);
        }
        HierarchicalConfiguration.Node node = this.createNode(sectionName);
        HierarchicalINIConfiguration.markSectionNode(node);
        this.getRootNode().addChild(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubnodeConfiguration getGlobalSection() {
        ViewNode parent = new ViewNode();
        for (ConfigurationNode node : this.getRootNode().getChildren()) {
            if (HierarchicalINIConfiguration.isSectionNode(node)) continue;
            ConfigurationNode configurationNode = node;
            synchronized (configurationNode) {
                parent.addChild(node);
            }
        }
        return this.createSubnodeConfiguration(parent);
    }

    private static void markSectionNode(ConfigurationNode node) {
        node.setReference(Boolean.TRUE);
    }

    private static boolean isSectionNode(ConfigurationNode node) {
        return node.getReference() != null || node.getChildrenCount() > 0;
    }
}

