/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.AsyncEmitter;
import rx.Completable;
import rx.CompletableEmitter;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.internal.operators.OnSubscribeFromEmitter;
import rx.internal.subscriptions.SequentialSubscription;
import rx.plugins.RxJavaHooks;

public final class CompletableFromEmitter
implements Completable.OnSubscribe {
    final Action1<CompletableEmitter> producer;

    public CompletableFromEmitter(Action1<CompletableEmitter> producer) {
        this.producer = producer;
    }

    @Override
    public void call(CompletableSubscriber t2) {
        FromEmitter emitter = new FromEmitter(t2);
        t2.onSubscribe(emitter);
        try {
            this.producer.call(emitter);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            emitter.onError(ex);
        }
    }

    static final class FromEmitter
    extends AtomicBoolean
    implements CompletableEmitter,
    Subscription {
        private static final long serialVersionUID = 5539301318568668881L;
        final CompletableSubscriber actual;
        final SequentialSubscription resource;

        public FromEmitter(CompletableSubscriber actual) {
            this.actual = actual;
            this.resource = new SequentialSubscription();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.actual.onCompleted();
                }
                finally {
                    this.resource.unsubscribe();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t2) {
            if (this.compareAndSet(false, true)) {
                try {
                    this.actual.onError(t2);
                }
                finally {
                    this.resource.unsubscribe();
                }
            } else {
                RxJavaHooks.onError(t2);
            }
        }

        @Override
        public void setSubscription(Subscription s2) {
            this.resource.update(s2);
        }

        @Override
        public void setCancellation(AsyncEmitter.Cancellable c) {
            this.setSubscription(new OnSubscribeFromEmitter.CancellableSubscription(c));
        }

        @Override
        public void unsubscribe() {
            if (this.compareAndSet(false, true)) {
                this.resource.unsubscribe();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get();
        }
    }
}

