/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;

public final class CompletableOnSubscribeConcatIterable
implements Completable.OnSubscribe {
    final Iterable<? extends Completable> sources;

    public CompletableOnSubscribeConcatIterable(Iterable<? extends Completable> sources) {
        this.sources = sources;
    }

    @Override
    public void call(CompletableSubscriber s2) {
        Iterator<? extends Completable> it;
        try {
            it = this.sources.iterator();
        }
        catch (Throwable e) {
            s2.onSubscribe(Subscriptions.unsubscribed());
            s2.onError(e);
            return;
        }
        if (it == null) {
            s2.onSubscribe(Subscriptions.unsubscribed());
            s2.onError(new NullPointerException("The iterator returned is null"));
            return;
        }
        ConcatInnerSubscriber inner = new ConcatInnerSubscriber(s2, it);
        s2.onSubscribe(inner.sd);
        inner.next();
    }

    static final class ConcatInnerSubscriber
    extends AtomicInteger
    implements CompletableSubscriber {
        private static final long serialVersionUID = -7965400327305809232L;
        final CompletableSubscriber actual;
        final Iterator<? extends Completable> sources;
        final SerialSubscription sd;

        public ConcatInnerSubscriber(CompletableSubscriber actual, Iterator<? extends Completable> sources) {
            this.actual = actual;
            this.sources = sources;
            this.sd = new SerialSubscription();
        }

        @Override
        public void onSubscribe(Subscription d) {
            this.sd.set(d);
        }

        @Override
        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            this.next();
        }

        void next() {
            if (this.sd.isUnsubscribed()) {
                return;
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
            Iterator<? extends Completable> a = this.sources;
            do {
                Completable c;
                boolean b;
                if (this.sd.isUnsubscribed()) {
                    return;
                }
                try {
                    b = a.hasNext();
                }
                catch (Throwable ex) {
                    this.actual.onError(ex);
                    return;
                }
                if (!b) {
                    this.actual.onCompleted();
                    return;
                }
                try {
                    c = a.next();
                }
                catch (Throwable ex) {
                    this.actual.onError(ex);
                    return;
                }
                if (c == null) {
                    this.actual.onError(new NullPointerException("The completable returned is null"));
                    return;
                }
                c.unsafeSubscribe(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

