/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.internal.operators.DeferredScalarSubscriberSafe;

public final class OnSubscribeCollect<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<T> source;
    final Func0<R> collectionFactory;
    final Action2<R, ? super T> collector;

    public OnSubscribeCollect(Observable<T> source2, Func0<R> collectionFactory, Action2<R, ? super T> collector) {
        this.source = source2;
        this.collectionFactory = collectionFactory;
        this.collector = collector;
    }

    @Override
    public void call(Subscriber<? super R> t2) {
        R initialValue;
        try {
            initialValue = this.collectionFactory.call();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            t2.onError(ex);
            return;
        }
        new CollectSubscriber<T, R>(t2, initialValue, this.collector).subscribeTo(this.source);
    }

    static final class CollectSubscriber<T, R>
    extends DeferredScalarSubscriberSafe<T, R> {
        final Action2<R, ? super T> collector;

        public CollectSubscriber(Subscriber<? super R> actual, R initialValue, Action2<R, ? super T> collector) {
            super(actual);
            this.value = initialValue;
            this.hasValue = true;
            this.collector = collector;
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            try {
                this.collector.call(this.value, t2);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(ex);
            }
        }
    }
}

