/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func2;
import rx.internal.operators.DeferredScalarSubscriber;

public final class OnSubscribeReduceSeed<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<T> source;
    final R initialValue;
    final Func2<R, ? super T, R> reducer;

    public OnSubscribeReduceSeed(Observable<T> source2, R initialValue, Func2<R, ? super T, R> reducer) {
        this.source = source2;
        this.initialValue = initialValue;
        this.reducer = reducer;
    }

    @Override
    public void call(Subscriber<? super R> t2) {
        new ReduceSeedSubscriber<T, R>(t2, this.initialValue, this.reducer).subscribeTo(this.source);
    }

    static final class ReduceSeedSubscriber<T, R>
    extends DeferredScalarSubscriber<T, R> {
        final Func2<R, ? super T, R> reducer;

        public ReduceSeedSubscriber(Subscriber<? super R> actual, R initialValue, Func2<R, ? super T, R> reducer) {
            super(actual);
            this.value = initialValue;
            this.hasValue = true;
            this.reducer = reducer;
        }

        @Override
        public void onNext(T t2) {
            try {
                this.value = this.reducer.call(this.value, t2);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.actual.onError(ex);
            }
        }
    }
}

