/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.MissingBackpressureException;
import rx.internal.operators.BackpressureUtils;

public final class OperatorBufferWithSize<T>
implements Observable.Operator<List<T>, T> {
    final int count;
    final int skip;

    public OperatorBufferWithSize(int count, int skip) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be greater than 0");
        }
        if (skip <= 0) {
            throw new IllegalArgumentException("skip must be greater than 0");
        }
        this.count = count;
        this.skip = skip;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super List<T>> child) {
        if (this.skip == this.count) {
            BufferExact parent = new BufferExact(child, this.count);
            child.add(parent);
            child.setProducer(parent.createProducer());
            return parent;
        }
        if (this.skip > this.count) {
            BufferSkip parent = new BufferSkip(child, this.count, this.skip);
            child.add(parent);
            child.setProducer(parent.createProducer());
            return parent;
        }
        BufferOverlap parent = new BufferOverlap(child, this.count, this.skip);
        child.add(parent);
        child.setProducer(parent.createProducer());
        return parent;
    }

    static final class BufferOverlap<T>
    extends Subscriber<T> {
        final Subscriber<? super List<T>> actual;
        final int count;
        final int skip;
        long index;
        final ArrayDeque<List<T>> queue;
        final AtomicLong requested;
        long produced;

        public BufferOverlap(Subscriber<? super List<T>> actual, int count, int skip) {
            this.actual = actual;
            this.count = count;
            this.skip = skip;
            this.queue = new ArrayDeque();
            this.requested = new AtomicLong();
            this.request(0L);
        }

        @Override
        public void onNext(T t2) {
            List<Object> b;
            long i = this.index;
            if (i == 0L) {
                b = new ArrayList(this.count);
                this.queue.offer(b);
            }
            this.index = ++i == (long)this.skip ? 0L : i;
            for (List<T> list : this.queue) {
                list.add(t2);
            }
            b = this.queue.peek();
            if (b != null && b.size() == this.count) {
                this.queue.poll();
                ++this.produced;
                this.actual.onNext(b);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.queue.clear();
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            long p = this.produced;
            if (p != 0L) {
                if (p > this.requested.get()) {
                    this.actual.onError(new MissingBackpressureException("More produced than requested? " + p));
                    return;
                }
                this.requested.addAndGet(-p);
            }
            BackpressureUtils.postCompleteDone(this.requested, this.queue, this.actual);
        }

        Producer createProducer() {
            return new BufferOverlapProducer();
        }

        final class BufferOverlapProducer
        extends AtomicBoolean
        implements Producer {
            private static final long serialVersionUID = -4015894850868853147L;

            BufferOverlapProducer() {
            }

            @Override
            public void request(long n) {
                BufferOverlap parent = BufferOverlap.this;
                if (BackpressureUtils.postCompleteRequest(parent.requested, n, parent.queue, parent.actual) && n != 0L) {
                    if (!this.get() && this.compareAndSet(false, true)) {
                        long u = BackpressureUtils.multiplyCap(parent.skip, n - 1L);
                        long v = BackpressureUtils.addCap(u, parent.count);
                        parent.request(v);
                    } else {
                        long u = BackpressureUtils.multiplyCap(parent.skip, n);
                        parent.request(u);
                    }
                }
            }
        }
    }

    static final class BufferSkip<T>
    extends Subscriber<T> {
        final Subscriber<? super List<T>> actual;
        final int count;
        final int skip;
        long index;
        List<T> buffer;

        public BufferSkip(Subscriber<? super List<T>> actual, int count, int skip) {
            this.actual = actual;
            this.count = count;
            this.skip = skip;
            this.request(0L);
        }

        @Override
        public void onNext(T t2) {
            long i = this.index;
            List<T> b = this.buffer;
            if (i == 0L) {
                b = new ArrayList<T>(this.count);
                this.buffer = b;
            }
            this.index = ++i == (long)this.skip ? 0L : i;
            if (b != null) {
                b.add(t2);
                if (b.size() == this.count) {
                    this.buffer = null;
                    this.actual.onNext(b);
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            this.buffer = null;
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            List<T> b = this.buffer;
            if (b != null) {
                this.buffer = null;
                this.actual.onNext(b);
            }
            this.actual.onCompleted();
        }

        Producer createProducer() {
            return new BufferSkipProducer();
        }

        final class BufferSkipProducer
        extends AtomicBoolean
        implements Producer {
            private static final long serialVersionUID = 3428177408082367154L;

            BufferSkipProducer() {
            }

            @Override
            public void request(long n) {
                if (n < 0L) {
                    throw new IllegalArgumentException("n >= 0 required but it was " + n);
                }
                if (n != 0L) {
                    BufferSkip parent = BufferSkip.this;
                    if (!this.get() && this.compareAndSet(false, true)) {
                        long u = BackpressureUtils.multiplyCap(n, parent.count);
                        long v = BackpressureUtils.multiplyCap(parent.skip - parent.count, n - 1L);
                        long w = BackpressureUtils.addCap(u, v);
                        parent.request(w);
                    } else {
                        long u = BackpressureUtils.multiplyCap(n, parent.skip);
                        parent.request(u);
                    }
                }
            }
        }
    }

    static final class BufferExact<T>
    extends Subscriber<T> {
        final Subscriber<? super List<T>> actual;
        final int count;
        List<T> buffer;

        public BufferExact(Subscriber<? super List<T>> actual, int count) {
            this.actual = actual;
            this.count = count;
            this.request(0L);
        }

        @Override
        public void onNext(T t2) {
            List<T> b = this.buffer;
            if (b == null) {
                b = new ArrayList<T>(this.count);
                this.buffer = b;
            }
            b.add(t2);
            if (b.size() == this.count) {
                this.buffer = null;
                this.actual.onNext(b);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.buffer = null;
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            List<T> b = this.buffer;
            if (b != null) {
                this.actual.onNext(b);
            }
            this.actual.onCompleted();
        }

        Producer createProducer() {
            return new Producer(){

                @Override
                public void request(long n) {
                    if (n < 0L) {
                        throw new IllegalArgumentException("n >= required but it was " + n);
                    }
                    if (n != 0L) {
                        long u = BackpressureUtils.multiplyCap(n, BufferExact.this.count);
                        BufferExact.this.request(u);
                    }
                }
            };
        }
    }
}

