/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import rx.BackpressureOverflow;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Action0;
import rx.internal.operators.NotificationLite;
import rx.internal.util.BackpressureDrainManager;

public class OperatorOnBackpressureBuffer<T>
implements Observable.Operator<T, T> {
    private final Long capacity;
    private final Action0 onOverflow;
    private final BackpressureOverflow.Strategy overflowStrategy;

    public static <T> OperatorOnBackpressureBuffer<T> instance() {
        return Holder.INSTANCE;
    }

    OperatorOnBackpressureBuffer() {
        this.capacity = null;
        this.onOverflow = null;
        this.overflowStrategy = BackpressureOverflow.ON_OVERFLOW_DEFAULT;
    }

    public OperatorOnBackpressureBuffer(long capacity) {
        this(capacity, null, BackpressureOverflow.ON_OVERFLOW_DEFAULT);
    }

    public OperatorOnBackpressureBuffer(long capacity, Action0 onOverflow) {
        this(capacity, onOverflow, BackpressureOverflow.ON_OVERFLOW_DEFAULT);
    }

    public OperatorOnBackpressureBuffer(long capacity, Action0 onOverflow, BackpressureOverflow.Strategy overflowStrategy) {
        if (capacity <= 0L) {
            throw new IllegalArgumentException("Buffer capacity must be > 0");
        }
        if (overflowStrategy == null) {
            throw new NullPointerException("The BackpressureOverflow strategy must not be null");
        }
        this.capacity = capacity;
        this.onOverflow = onOverflow;
        this.overflowStrategy = overflowStrategy;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        BufferSubscriber<T> parent = new BufferSubscriber<T>(child, this.capacity, this.onOverflow, this.overflowStrategy);
        child.add(parent);
        child.setProducer(parent.manager());
        return parent;
    }

    static final class BufferSubscriber<T>
    extends Subscriber<T>
    implements BackpressureDrainManager.BackpressureQueueCallback {
        private final ConcurrentLinkedQueue<Object> queue = new ConcurrentLinkedQueue();
        private final AtomicLong capacity;
        private final Subscriber<? super T> child;
        private final AtomicBoolean saturated = new AtomicBoolean(false);
        private final BackpressureDrainManager manager;
        private final NotificationLite<T> on = NotificationLite.instance();
        private final Action0 onOverflow;
        private final BackpressureOverflow.Strategy overflowStrategy;

        public BufferSubscriber(Subscriber<? super T> child, Long capacity, Action0 onOverflow, BackpressureOverflow.Strategy overflowStrategy) {
            this.child = child;
            this.capacity = capacity != null ? new AtomicLong(capacity) : null;
            this.onOverflow = onOverflow;
            this.manager = new BackpressureDrainManager(this);
            this.overflowStrategy = overflowStrategy;
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        @Override
        public void onCompleted() {
            if (!this.saturated.get()) {
                this.manager.terminateAndDrain();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.saturated.get()) {
                this.manager.terminateAndDrain(e);
            }
        }

        @Override
        public void onNext(T t2) {
            if (!this.assertCapacity()) {
                return;
            }
            this.queue.offer(this.on.next(t2));
            this.manager.drain();
        }

        @Override
        public boolean accept(Object value) {
            return this.on.accept(this.child, value);
        }

        @Override
        public void complete(Throwable exception) {
            if (exception != null) {
                this.child.onError(exception);
            } else {
                this.child.onCompleted();
            }
        }

        @Override
        public Object peek() {
            return this.queue.peek();
        }

        @Override
        public Object poll() {
            Object value = this.queue.poll();
            if (this.capacity != null && value != null) {
                this.capacity.incrementAndGet();
            }
            return value;
        }

        private boolean assertCapacity() {
            long currCapacity;
            if (this.capacity == null) {
                return true;
            }
            do {
                boolean hasCapacity;
                block7: {
                    if ((currCapacity = this.capacity.get()) > 0L) continue;
                    hasCapacity = false;
                    try {
                        hasCapacity = this.overflowStrategy.mayAttemptDrop() && this.poll() != null;
                    }
                    catch (MissingBackpressureException e) {
                        if (!this.saturated.compareAndSet(false, true)) break block7;
                        this.unsubscribe();
                        this.child.onError(e);
                    }
                }
                if (this.onOverflow != null) {
                    try {
                        this.onOverflow.call();
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        this.manager.terminateAndDrain(e);
                        return false;
                    }
                }
                if (hasCapacity) continue;
                return false;
            } while (!this.capacity.compareAndSet(currCapacity, currCapacity - 1L));
            return true;
        }

        protected Producer manager() {
            return this.manager;
        }
    }

    static final class Holder {
        static final OperatorOnBackpressureBuffer<?> INSTANCE = new OperatorOnBackpressureBuffer();

        Holder() {
        }
    }
}

