/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;

public final class OperatorSubscribeOn<T>
implements Observable.OnSubscribe<T> {
    final Scheduler scheduler;
    final Observable<T> source;

    public OperatorSubscribeOn(Observable<T> source2, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.source = source2;
    }

    @Override
    public void call(final Subscriber<? super T> subscriber) {
        final Scheduler.Worker inner = this.scheduler.createWorker();
        subscriber.add(inner);
        inner.schedule(new Action0(){

            @Override
            public void call() {
                final Thread t2 = Thread.currentThread();
                Subscriber s2 = new Subscriber<T>(subscriber){

                    @Override
                    public void onNext(T t22) {
                        subscriber.onNext(t22);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onError(Throwable e) {
                        try {
                            subscriber.onError(e);
                        }
                        finally {
                            inner.unsubscribe();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onCompleted() {
                        try {
                            subscriber.onCompleted();
                        }
                        finally {
                            inner.unsubscribe();
                        }
                    }

                    @Override
                    public void setProducer(final Producer p) {
                        subscriber.setProducer(new Producer(){

                            @Override
                            public void request(final long n) {
                                if (t2 == Thread.currentThread()) {
                                    p.request(n);
                                } else {
                                    inner.schedule(new Action0(){

                                        @Override
                                        public void call() {
                                            p.request(n);
                                        }
                                    });
                                }
                            }
                        });
                    }
                };
                OperatorSubscribeOn.this.source.unsafeSubscribe(s2);
            }
        });
    }
}

