/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.FuncN;
import rx.observers.SerializedSubscriber;
import rx.plugins.RxJavaHooks;

public final class OperatorWithLatestFromMany<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<T> main;
    final Observable<?>[] others;
    final Iterable<Observable<?>> othersIterable;
    final FuncN<R> combiner;

    public OperatorWithLatestFromMany(Observable<T> main, Observable<?>[] others, Iterable<Observable<?>> othersIterable, FuncN<R> combiner) {
        this.main = main;
        this.others = others;
        this.othersIterable = othersIterable;
        this.combiner = combiner;
    }

    @Override
    public void call(Subscriber<? super R> t2) {
        Observable<?>[] sources;
        SerializedSubscriber<R> serial = new SerializedSubscriber<R>(t2);
        int n = 0;
        if (this.others != null) {
            sources = this.others;
            n = sources.length;
        } else {
            sources = new Observable[8];
            for (Observable<?> o : this.othersIterable) {
                if (n == sources.length) {
                    sources = Arrays.copyOf(sources, n + (n >> 2));
                }
                sources[n++] = o;
            }
        }
        WithLatestMainSubscriber parent = new WithLatestMainSubscriber(t2, this.combiner, n);
        serial.add(parent);
        for (int i = 0; i < n; ++i) {
            if (serial.isUnsubscribed()) {
                return;
            }
            WithLatestOtherSubscriber inner = new WithLatestOtherSubscriber(parent, i + 1);
            parent.add(inner);
            Observable<?> o = sources[i];
            o.unsafeSubscribe(inner);
        }
        this.main.unsafeSubscribe(parent);
    }

    static final class WithLatestOtherSubscriber
    extends Subscriber<Object> {
        final WithLatestMainSubscriber<?, ?> parent;
        final int index;

        public WithLatestOtherSubscriber(WithLatestMainSubscriber<?, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onNext(Object t2) {
            this.parent.innerNext(this.index, t2);
        }

        @Override
        public void onError(Throwable e) {
            this.parent.innerError(this.index, e);
        }

        @Override
        public void onCompleted() {
            this.parent.innerComplete(this.index);
        }
    }

    static final class WithLatestMainSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final FuncN<R> combiner;
        final AtomicReferenceArray<Object> current;
        static final Object EMPTY = new Object();
        final AtomicInteger ready;
        boolean done;

        public WithLatestMainSubscriber(Subscriber<? super R> actual, FuncN<R> combiner, int n) {
            this.actual = actual;
            this.combiner = combiner;
            AtomicReferenceArray<Object> array = new AtomicReferenceArray<Object>(n + 1);
            for (int i = 0; i <= n; ++i) {
                array.lazySet(i, EMPTY);
            }
            this.current = array;
            this.ready = new AtomicInteger(n);
            this.request(0L);
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            if (this.ready.get() == 0) {
                R result;
                AtomicReferenceArray<Object> array = this.current;
                int n = array.length();
                array.lazySet(0, t2);
                Object[] copy = new Object[array.length()];
                for (int i = 0; i < n; ++i) {
                    copy[i] = array.get(i);
                }
                try {
                    result = this.combiner.call(copy);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.onError(ex);
                    return;
                }
                this.actual.onNext(result);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaHooks.onError(e);
                return;
            }
            this.done = true;
            this.unsubscribe();
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.unsubscribe();
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            super.setProducer(p);
            this.actual.setProducer(p);
        }

        void innerNext(int index, Object o) {
            Object last = this.current.getAndSet(index, o);
            if (last == EMPTY) {
                this.ready.decrementAndGet();
            }
        }

        void innerError(int index, Throwable e) {
            this.onError(e);
        }

        void innerComplete(int index) {
            if (this.current.get(index) == EMPTY) {
                this.onCompleted();
            }
        }
    }
}

