/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager;

import com.github.philippheuer.credentialmanager.api.IStorageBackend;
import com.github.philippheuer.credentialmanager.domain.AuthenticationController;
import com.github.philippheuer.credentialmanager.domain.Credential;
import com.github.philippheuer.credentialmanager.domain.IdentityProvider;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.identityprovider.OAuth2IdentityProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialManager {
    private static final Logger log = LoggerFactory.getLogger(CredentialManager.class);
    private final Object $lock = new Object[0];
    private final IStorageBackend storageBackend;
    private final AuthenticationController authenticationController;
    private final Map<String, IdentityProvider> identityProvidersByLowerName = new ConcurrentHashMap<String, IdentityProvider>();
    private List<Credential> credentials;

    public CredentialManager(IStorageBackend storageBackend, AuthenticationController authenticationController) {
        this.storageBackend = storageBackend;
        this.authenticationController = authenticationController;
        authenticationController.setCredentialManager(this);
        this.load();
    }

    public void registerIdentityProvider(IdentityProvider identityProvider) {
        log.debug("Trying to register IdentityProvider {} [Type: {}]", (Object)identityProvider.getProviderName(), (Object)identityProvider.getProviderType());
        String lowerName = identityProvider.getProviderName().toLowerCase();
        IdentityProvider previous = this.identityProvidersByLowerName.putIfAbsent(lowerName, identityProvider);
        if (previous != null) {
            String msg = "Identity Provider " + identityProvider.getProviderName() + " was already registered!";
            if (identityProvider.getClass().isAssignableFrom(previous.getClass())) {
                log.info(msg);
                return;
            }
            if (!previous.getClass().isAssignableFrom(identityProvider.getClass()) || !this.identityProvidersByLowerName.replace(identityProvider.getProviderName().toLowerCase(), previous, identityProvider)) {
                throw new RuntimeException(msg);
            }
        }
        identityProvider.setCredentialManager(this);
        log.debug("Registered IdentityProvider {} [Type: {}]", (Object)identityProvider.getProviderName(), (Object)identityProvider.getProviderType());
        log.debug("A total of {} IdentityProviders have been registered!", (Object)this.identityProvidersByLowerName.size());
    }

    public List<IdentityProvider> getIdentityProviders() {
        return Collections.unmodifiableList(new ArrayList<IdentityProvider>(this.identityProvidersByLowerName.values()));
    }

    public Optional<IdentityProvider> getIdentityProviderByName(String identityProviderName) {
        return Optional.ofNullable(this.identityProvidersByLowerName.get(identityProviderName.toLowerCase()));
    }

    public <T> Optional<T> getIdentityProviderByName(String identityProviderName, Class<T> identityProviderClass) {
        return this.getIdentityProviderByName(identityProviderName).filter(i -> identityProviderClass.isAssignableFrom(i.getClass())).map(identityProviderClass::cast);
    }

    public Optional<OAuth2IdentityProvider> getOAuth2IdentityProviderByName(String identityProviderName) {
        return this.getIdentityProviderByName(identityProviderName).filter(i -> i instanceof OAuth2IdentityProvider).map(i -> (OAuth2IdentityProvider)i);
    }

    public void addCredential(String providerName, Credential credential) {
        if (credential instanceof OAuth2Credential) {
            OAuth2Credential oAuth2Credential = (OAuth2Credential)credential;
            OAuth2IdentityProvider oAuth2IdentityProvider = this.getIdentityProviderByName(providerName).filter(idp -> idp.getProviderType().equalsIgnoreCase("oauth2") && idp instanceof OAuth2IdentityProvider).map(idp -> (OAuth2IdentityProvider)idp).orElseThrow(() -> new RuntimeException("Can't find a unique identity provider for the specified credential!"));
            Optional<OAuth2Credential> enrichedCredential = oAuth2IdentityProvider.getAdditionalCredentialInformation(oAuth2Credential);
            if (enrichedCredential.isPresent()) {
                credential = enrichedCredential.get();
            }
        }
        this.credentials.add(credential);
    }

    public Optional<OAuth2Credential> getOAuth2CredentialByUserId(@NotNull String userId) {
        for (Credential entry : this.credentials) {
            OAuth2Credential credential;
            if (!(entry instanceof OAuth2Credential) || !userId.equalsIgnoreCase((credential = (OAuth2Credential)entry).getUserId())) continue;
            return Optional.of(credential);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.$lock;
        synchronized (object) {
            this.credentials = this.storageBackend.loadCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Object object = this.$lock;
        synchronized (object) {
            this.storageBackend.saveCredentials(this.credentials);
        }
    }

    public IStorageBackend getStorageBackend() {
        return this.storageBackend;
    }

    public AuthenticationController getAuthenticationController() {
        return this.authenticationController;
    }

    public List<Credential> getCredentials() {
        return this.credentials;
    }

    protected Map<String, IdentityProvider> getIdentityProvidersByLowerName() {
        return this.identityProvidersByLowerName;
    }
}

