/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager.domain;

import com.morelaid.streamingmodule.external.jackson.annotation.JsonAnyGetter;
import com.morelaid.streamingmodule.external.jackson.annotation.JsonAnySetter;
import com.morelaid.streamingmodule.external.jackson.annotation.JsonIgnore;
import com.morelaid.streamingmodule.external.jackson.databind.PropertyNamingStrategies;
import com.morelaid.streamingmodule.external.jackson.databind.annotation.JsonNaming;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class DeviceAuthorization {
    @NotNull
    private String deviceCode;
    @NotNull
    private String userCode;
    @NotNull
    private String verificationUri;
    private int expiresIn;
    private int interval = 5;
    @Nullable
    private String verificationUriComplete;
    @JsonAnyGetter
    @JsonAnySetter
    private Map<String, Object> customProperties = new HashMap<String, Object>(0);
    private Instant issuedAt = Instant.now();

    @JsonIgnore
    public Instant getExpiresAt() {
        return this.expiresIn > 0 ? this.issuedAt.plusSeconds(this.expiresIn) : Instant.MAX;
    }

    public String getCompleteUri() {
        if (this.verificationUriComplete != null && !this.verificationUriComplete.isEmpty()) {
            return this.verificationUriComplete;
        }
        HttpUrl url = HttpUrl.parse(this.verificationUri);
        if (url == null) {
            return null;
        }
        if (this.userCode.equals(url.queryParameter("user_code"))) {
            return this.verificationUri;
        }
        return url.newBuilder().addQueryParameter("user_code", this.userCode).build().toString();
    }

    @NotNull
    public String getDeviceCode() {
        return this.deviceCode;
    }

    @NotNull
    public String getUserCode() {
        return this.userCode;
    }

    @NotNull
    public String getVerificationUri() {
        return this.verificationUri;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public int getInterval() {
        return this.interval;
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceAuthorization)) {
            return false;
        }
        DeviceAuthorization other = (DeviceAuthorization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiresIn() != other.getExpiresIn()) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        String this$deviceCode = this.getDeviceCode();
        String other$deviceCode = other.getDeviceCode();
        if (this$deviceCode == null ? other$deviceCode != null : !this$deviceCode.equals(other$deviceCode)) {
            return false;
        }
        String this$userCode = this.getUserCode();
        String other$userCode = other.getUserCode();
        if (this$userCode == null ? other$userCode != null : !this$userCode.equals(other$userCode)) {
            return false;
        }
        String this$verificationUri = this.getVerificationUri();
        String other$verificationUri = other.getVerificationUri();
        if (this$verificationUri == null ? other$verificationUri != null : !this$verificationUri.equals(other$verificationUri)) {
            return false;
        }
        String this$verificationUriComplete = this.getVerificationUriComplete();
        String other$verificationUriComplete = other.getVerificationUriComplete();
        if (this$verificationUriComplete == null ? other$verificationUriComplete != null : !this$verificationUriComplete.equals(other$verificationUriComplete)) {
            return false;
        }
        Map<String, Object> this$customProperties = this.getCustomProperties();
        Map<String, Object> other$customProperties = other.getCustomProperties();
        if (this$customProperties == null ? other$customProperties != null : !((Object)this$customProperties).equals(other$customProperties)) {
            return false;
        }
        Instant this$issuedAt = this.getIssuedAt();
        Instant other$issuedAt = other.getIssuedAt();
        return !(this$issuedAt == null ? other$issuedAt != null : !((Object)this$issuedAt).equals(other$issuedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceAuthorization;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExpiresIn();
        result = result * 59 + this.getInterval();
        String $deviceCode = this.getDeviceCode();
        result = result * 59 + ($deviceCode == null ? 43 : $deviceCode.hashCode());
        String $userCode = this.getUserCode();
        result = result * 59 + ($userCode == null ? 43 : $userCode.hashCode());
        String $verificationUri = this.getVerificationUri();
        result = result * 59 + ($verificationUri == null ? 43 : $verificationUri.hashCode());
        String $verificationUriComplete = this.getVerificationUriComplete();
        result = result * 59 + ($verificationUriComplete == null ? 43 : $verificationUriComplete.hashCode());
        Map<String, Object> $customProperties = this.getCustomProperties();
        result = result * 59 + ($customProperties == null ? 43 : ((Object)$customProperties).hashCode());
        Instant $issuedAt = this.getIssuedAt();
        result = result * 59 + ($issuedAt == null ? 43 : ((Object)$issuedAt).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceAuthorization(deviceCode=" + this.getDeviceCode() + ", userCode=" + this.getUserCode() + ", verificationUri=" + this.getVerificationUri() + ", expiresIn=" + this.getExpiresIn() + ", interval=" + this.getInterval() + ", verificationUriComplete=" + this.getVerificationUriComplete() + ", customProperties=" + this.getCustomProperties() + ", issuedAt=" + this.getIssuedAt() + ")";
    }

    private void setDeviceCode(@NotNull String deviceCode) {
        if (deviceCode == null) {
            throw new NullPointerException("deviceCode is marked non-null but is null");
        }
        this.deviceCode = deviceCode;
    }

    private void setUserCode(@NotNull String userCode) {
        if (userCode == null) {
            throw new NullPointerException("userCode is marked non-null but is null");
        }
        this.userCode = userCode;
    }

    private void setVerificationUri(@NotNull String verificationUri) {
        if (verificationUri == null) {
            throw new NullPointerException("verificationUri is marked non-null but is null");
        }
        this.verificationUri = verificationUri;
    }

    private void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    private void setInterval(int interval) {
        this.interval = interval;
    }

    private void setVerificationUriComplete(@Nullable String verificationUriComplete) {
        this.verificationUriComplete = verificationUriComplete;
    }

    private void setCustomProperties(Map<String, Object> customProperties) {
        this.customProperties = customProperties;
    }

    private void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }

    public DeviceAuthorization() {
    }

    public DeviceAuthorization(@NotNull String deviceCode, @NotNull String userCode, @NotNull String verificationUri, int expiresIn, int interval, @Nullable String verificationUriComplete, Map<String, Object> customProperties, Instant issuedAt) {
        if (deviceCode == null) {
            throw new NullPointerException("deviceCode is marked non-null but is null");
        }
        if (userCode == null) {
            throw new NullPointerException("userCode is marked non-null but is null");
        }
        if (verificationUri == null) {
            throw new NullPointerException("verificationUri is marked non-null but is null");
        }
        this.deviceCode = deviceCode;
        this.userCode = userCode;
        this.verificationUri = verificationUri;
        this.expiresIn = expiresIn;
        this.interval = interval;
        this.verificationUriComplete = verificationUriComplete;
        this.customProperties = customProperties;
        this.issuedAt = issuedAt;
    }

    @Nullable
    protected String getVerificationUriComplete() {
        return this.verificationUriComplete;
    }
}

