/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.events4j.api.domain;

import com.github.philippheuer.events4j.api.domain.IDisposable;
import com.github.philippheuer.events4j.api.domain.IEventSubscription;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;

public class DisposableWrapper
implements IEventSubscription {
    private final IDisposable disposable;
    private final String id;
    private final Class eventType;
    private final Consumer consumer;
    private final Map<String, IEventSubscription> activeSubscriptions;

    public DisposableWrapper(IDisposable disposable, String id, Class eventType, Consumer consumer, Map<String, IEventSubscription> activeSubscriptions) {
        this.disposable = disposable;
        this.id = id;
        this.eventType = eventType;
        this.consumer = consumer;
        this.activeSubscriptions = activeSubscriptions;
        activeSubscriptions.put(id, this);
    }

    @Override
    public void dispose() {
        if (!this.disposable.isDisposed()) {
            this.disposable.dispose();
            this.activeSubscriptions.remove(this.id);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    @Generated
    public IDisposable getDisposable() {
        return this.disposable;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Class getEventType() {
        return this.eventType;
    }

    @Override
    @Generated
    public Consumer getConsumer() {
        return this.consumer;
    }

    @Generated
    public Map<String, IEventSubscription> getActiveSubscriptions() {
        return this.activeSubscriptions;
    }

    @Generated
    public String toString() {
        return "DisposableWrapper(disposable=" + this.getDisposable() + ", id=" + this.getId() + ", eventType=" + this.getEventType() + ", consumer=" + this.getConsumer() + ")";
    }
}

