/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.field.types;

import com.morelaid.streamingmodule.external.j256.ormlite.field.FieldType;
import com.morelaid.streamingmodule.external.j256.ormlite.field.SqlType;
import com.morelaid.streamingmodule.external.j256.ormlite.field.types.BaseDataType;
import com.morelaid.streamingmodule.external.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.Currency;

public class CurrencyType
extends BaseDataType {
    public static int DEFAULT_WIDTH = 30;
    private static final CurrencyType singleTon = new CurrencyType();

    public static CurrencyType getSingleton() {
        return singleTon;
    }

    public CurrencyType() {
        super(SqlType.STRING, new Class[]{Currency.class});
    }

    public CurrencyType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
        Currency currency = (Currency)javaObject;
        return currency.getCurrencyCode();
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return Currency.getInstance(defaultStr).getCurrencyCode();
        }
        catch (IllegalArgumentException iae) {
            throw new SQLException("Problems with field " + fieldType + " parsing default Currency '", iae);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getString(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        String currencyStr = (String)sqlArg;
        try {
            return Currency.getInstance(currencyStr);
        }
        catch (IllegalArgumentException iae) {
            throw new SQLException("Problems with column " + columnPos + " parsing Currency '" + currencyStr + "'", iae);
        }
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }
}

