/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.jdbc;

import com.morelaid.streamingmodule.external.j256.ormlite.field.SqlType;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class TypeValMapper {
    private static final Map<SqlType, int[]> typeToValMap = new HashMap<SqlType, int[]>();

    public static int getTypeValForSqlType(SqlType sqlType) throws SQLException {
        int[] typeVals = typeToValMap.get((Object)sqlType);
        if (typeVals == null) {
            throw new SQLException("SqlType is unknown to type val mapping: " + (Object)((Object)sqlType));
        }
        if (typeVals.length == 0) {
            throw new SQLException("SqlType does not have any JDBC type value mapping: " + (Object)((Object)sqlType));
        }
        return typeVals[0];
    }

    public static SqlType getSqlTypeForTypeVal(int typeVal) {
        for (Map.Entry<SqlType, int[]> entry : typeToValMap.entrySet()) {
            for (int val : entry.getValue()) {
                if (val != typeVal) continue;
                return entry.getKey();
            }
        }
        return SqlType.UNKNOWN;
    }

    static {
        for (SqlType sqlType : SqlType.values()) {
            int[] values2;
            switch (sqlType) {
                case STRING: {
                    values2 = new int[]{12};
                    break;
                }
                case LONG_STRING: {
                    values2 = new int[]{-1};
                    break;
                }
                case DATE: {
                    values2 = new int[]{93};
                    break;
                }
                case BOOLEAN: {
                    values2 = new int[]{16};
                    break;
                }
                case CHAR: {
                    values2 = new int[]{1};
                    break;
                }
                case BYTE: {
                    values2 = new int[]{-6};
                    break;
                }
                case BYTE_ARRAY: {
                    values2 = new int[]{-3};
                    break;
                }
                case SHORT: {
                    values2 = new int[]{5};
                    break;
                }
                case INTEGER: {
                    values2 = new int[]{4};
                    break;
                }
                case LONG: {
                    values2 = new int[]{-5};
                    break;
                }
                case FLOAT: {
                    values2 = new int[]{6};
                    break;
                }
                case DOUBLE: {
                    values2 = new int[]{8};
                    break;
                }
                case SERIALIZABLE: {
                    values2 = new int[]{-3};
                    break;
                }
                case BLOB: {
                    values2 = new int[]{2004};
                    break;
                }
                case BIG_DECIMAL: {
                    values2 = new int[]{3, 2};
                    break;
                }
                case UUID: {
                    values2 = new int[]{1111};
                    break;
                }
                case OTHER: {
                    values2 = new int[]{1111};
                    break;
                }
                case UNKNOWN: {
                    values2 = new int[]{};
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No JDBC mapping for unknown SqlType " + (Object)((Object)sqlType));
                }
            }
            typeToValMap.put(sqlType, values2);
        }
    }
}

