/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.misc;

import com.morelaid.streamingmodule.external.j256.ormlite.logger.Logger;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.LoggerFactory;
import com.morelaid.streamingmodule.external.j256.ormlite.support.CompiledStatement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class WrappedStatement
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(WrappedStatement.class);
    private final CompiledStatement statement;
    private final CompiledStatement statementProxy;
    private boolean closeCalled;

    public WrappedStatement(CompiledStatement statement) {
        this.statement = statement;
        this.statementProxy = (CompiledStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CompiledStatement.class}, (InvocationHandler)this);
    }

    public CompiledStatement getStatementProxy() {
        return this.statementProxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        logger.trace("{}: running method on statement: {}", this, (Object)method.getName());
        try {
            Object result = method.invoke((Object)this.statement, args2);
            if (method.getName().equals("close")) {
                this.closeCalled = true;
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public boolean isClosed() {
        if (this.closeCalled) {
            return true;
        }
        logger.error("{}: CompiledStatement was not closed: {}", this, (Object)this.statement);
        return false;
    }
}

