/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.stmt.mapped;

import com.morelaid.streamingmodule.external.j256.ormlite.dao.Dao;
import com.morelaid.streamingmodule.external.j256.ormlite.dao.ObjectCache;
import com.morelaid.streamingmodule.external.j256.ormlite.db.DatabaseType;
import com.morelaid.streamingmodule.external.j256.ormlite.field.FieldType;
import com.morelaid.streamingmodule.external.j256.ormlite.stmt.mapped.MappedQueryForFieldEq;
import com.morelaid.streamingmodule.external.j256.ormlite.support.DatabaseConnection;
import com.morelaid.streamingmodule.external.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

public class MappedRefresh<T, ID>
extends MappedQueryForFieldEq<T, ID> {
    private MappedRefresh(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType[] resultFieldTypes) {
        super(dao, tableInfo, statement, argFieldTypes, resultFieldTypes, "refresh");
    }

    public int executeRefresh(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        Object id = this.idField.extractJavaFieldValue(data);
        Object result = super.execute(databaseConnection, id, null);
        if (result == null) {
            return 0;
        }
        for (FieldType fieldType : this.resultsFieldTypes) {
            if (fieldType == this.idField) continue;
            fieldType.assignField(this.connectionSource, data, fieldType.extractJavaFieldValue(result), false, objectCache);
        }
        return 1;
    }

    public static <T, ID> MappedRefresh<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot refresh " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        String statement = MappedRefresh.buildStatement(databaseType, tableInfo, idField);
        return new MappedRefresh<T, ID>(dao, tableInfo, statement, new FieldType[]{tableInfo.getIdField()}, tableInfo.getFieldTypes());
    }
}

