/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j;

import com.github.philippheuer.events4j.core.EventManager;
import com.morelaid.streamingmodule.external.twitch4j.TwitchClientHelper;
import com.morelaid.streamingmodule.external.twitch4j.chat.ITwitchChat;
import com.morelaid.streamingmodule.external.twitch4j.eventsub.socket.IEventSubSocket;
import com.morelaid.streamingmodule.external.twitch4j.extensions.TwitchExtensions;
import com.morelaid.streamingmodule.external.twitch4j.graphql.TwitchGraphQL;
import com.morelaid.streamingmodule.external.twitch4j.helix.TwitchHelix;
import com.morelaid.streamingmodule.external.twitch4j.kraken.TwitchKraken;
import com.morelaid.streamingmodule.external.twitch4j.modules.ModuleLoader;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.ITwitchPubSub;
import com.morelaid.streamingmodule.external.twitch4j.tmi.TwitchMessagingInterface;
import org.jetbrains.annotations.ApiStatus;

public interface ITwitchClient
extends AutoCloseable {
    public EventManager getEventManager();

    @Deprecated
    public TwitchExtensions getExtensions();

    public TwitchHelix getHelix();

    @Deprecated
    public TwitchKraken getKraken();

    public TwitchMessagingInterface getMessagingInterface();

    public ITwitchChat getChat();

    @ApiStatus.Experimental
    public IEventSubSocket getEventSocket();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public ITwitchPubSub getPubSub();

    public TwitchGraphQL getGraphQL();

    public ModuleLoader getModuleLoader();

    public TwitchClientHelper getClientHelper();

    @Override
    default public void close() {
        TwitchClientHelper clientHelper;
        ITwitchChat chat = null;
        try {
            chat = this.getChat();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (chat != null) {
            chat.close();
        }
        try {
            this.getEventSocket().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ITwitchPubSub pubsub = null;
        try {
            pubsub = this.getPubSub();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pubsub != null) {
            pubsub.close();
        }
        if ((clientHelper = this.getClientHelper()) != null) {
            clientHelper.close();
        }
    }
}

