/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.core.EventManager;
import com.morelaid.streamingmodule.external.twitch4j.ITwitchClient;
import com.morelaid.streamingmodule.external.twitch4j.TwitchClientHelper;
import com.morelaid.streamingmodule.external.twitch4j.chat.TwitchChat;
import com.morelaid.streamingmodule.external.twitch4j.eventsub.socket.IEventSubSocket;
import com.morelaid.streamingmodule.external.twitch4j.extensions.TwitchExtensions;
import com.morelaid.streamingmodule.external.twitch4j.graphql.TwitchGraphQL;
import com.morelaid.streamingmodule.external.twitch4j.helix.TwitchHelix;
import com.morelaid.streamingmodule.external.twitch4j.kraken.TwitchKraken;
import com.morelaid.streamingmodule.external.twitch4j.modules.ModuleLoader;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.TwitchPubSub;
import com.morelaid.streamingmodule.external.twitch4j.tmi.TwitchMessagingInterface;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchClient
implements ITwitchClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchClient.class);
    private final EventManager eventManager;
    private final TwitchExtensions extensions;
    private final TwitchHelix helix;
    private final TwitchKraken kraken;
    private final TwitchMessagingInterface messagingInterface;
    private final TwitchChat chat;
    private final IEventSubSocket eventSocket;
    private final TwitchPubSub pubsub;
    private final TwitchGraphQL graphql;
    private final ModuleLoader moduleLoader;
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final TwitchClientHelper clientHelper;

    @ApiStatus.Internal
    public TwitchClient(EventManager eventManager, TwitchExtensions extensions, TwitchHelix helix, TwitchKraken kraken, TwitchMessagingInterface messagingInterface, TwitchChat chat, TwitchPubSub pubsub, TwitchGraphQL graphql, IEventSubSocket eventSocket, ScheduledThreadPoolExecutor threadPoolExecutor, CredentialManager credentialManager, OAuth2Credential defaultAuthToken) {
        this.eventManager = eventManager;
        this.extensions = extensions;
        this.helix = helix;
        this.kraken = kraken;
        this.messagingInterface = messagingInterface;
        this.chat = chat;
        this.eventSocket = eventSocket;
        this.pubsub = pubsub;
        this.graphql = graphql;
        this.clientHelper = new TwitchClientHelper(helix, eventManager, threadPoolExecutor, credentialManager, defaultAuthToken);
        this.scheduledThreadPoolExecutor = threadPoolExecutor;
        this.moduleLoader = new ModuleLoader(this);
        this.eventManager.getServiceMediator().addService("twitch4j", this);
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    @Deprecated
    public TwitchExtensions getExtensions() {
        if (this.extensions == null) {
            throw new RuntimeException("You have not enabled the Extensions Module! Please check out the documentation on Twitch4J -> Extensions.");
        }
        return this.extensions;
    }

    @Override
    public TwitchHelix getHelix() {
        if (this.helix == null) {
            throw new RuntimeException("You have not enabled the Helix Module! Please check out the documentation on Twitch4J -> Helix.");
        }
        return this.helix;
    }

    @Override
    @Deprecated
    public TwitchKraken getKraken() {
        if (this.kraken == null) {
            throw new RuntimeException("You have not enabled the Kraken Module! Please check out the documentation on Twitch4J -> Kraken.");
        }
        return this.kraken;
    }

    @Override
    public TwitchMessagingInterface getMessagingInterface() {
        if (this.messagingInterface == null) {
            throw new RuntimeException("You have not enabled the Twitch Messaging Interface Module! Please check out the documentation on Twitch4J -> TMI.");
        }
        return this.messagingInterface;
    }

    @Override
    public TwitchChat getChat() {
        if (this.chat == null) {
            throw new RuntimeException("You have not enabled the Chat Module! Please check out the documentation on Twitch4J -> Chat.");
        }
        return this.chat;
    }

    @Override
    public IEventSubSocket getEventSocket() {
        if (this.eventSocket == null) {
            throw new RuntimeException("You have not enabled the EventSub over WebSocket Module! Please check out the documentation on Twitch4J -> EventSub.");
        }
        return this.eventSocket;
    }

    @Override
    public TwitchPubSub getPubSub() {
        if (this.pubsub == null) {
            throw new RuntimeException("You have not enabled the PubSub Module! Please check out the documentation on Twitch4J -> PubSub.");
        }
        return this.pubsub;
    }

    @Override
    public TwitchGraphQL getGraphQL() {
        if (this.graphql == null) {
            throw new RuntimeException("You have not enabled the GraphQL Module! Please check out the documentation on Twitch4J -> GraphQL.");
        }
        return this.graphql;
    }

    @Override
    public void close() {
        BasicThreadFactory threadFactory;
        String pattern;
        log.info("Closing TwitchClient ...");
        ITwitchClient.super.close();
        if (this.scheduledThreadPoolExecutor.getThreadFactory() instanceof BasicThreadFactory && (pattern = (threadFactory = (BasicThreadFactory)this.scheduledThreadPoolExecutor.getThreadFactory()).getNamingPattern()) != null && pattern.startsWith("twitch4j-") && pattern.endsWith("-%d")) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
    }

    @Override
    @Generated
    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    @Override
    @Generated
    public TwitchClientHelper getClientHelper() {
        return this.clientHelper;
    }
}

