/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.common.util;

import java.security.SecureRandom;
import java.util.Random;

public class CryptoUtils {
    private static final ThreadLocal<Random> RANDOM = ThreadLocal.withInitial(SecureRandom::new);
    private static final char[] CHARSET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();

    public static String generateNonce(int length) {
        Random rand = RANDOM.get();
        StringBuilder sb = new StringBuilder(length);
        while (sb.length() < length) {
            sb.append(CHARSET[rand.nextInt(CHARSET.length)]);
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String hex) {
        int n = hex.length() / 2;
        byte[] bytes = new byte[n];
        for (int i = 0; i < n; ++i) {
            char a = hex.charAt(i * 2);
            char b = hex.charAt(i * 2 + 1);
            bytes[i] = (byte)((Character.digit(a, 16) << 4) + Character.digit(b, 16));
        }
        return bytes;
    }
}

