/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.eventsub.socket;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.api.IEventManager;
import com.morelaid.streamingmodule.external.twitch4j.eventsub.EventSubSubscription;
import com.morelaid.streamingmodule.external.twitch4j.eventsub.EventSubTransport;
import com.morelaid.streamingmodule.external.twitch4j.eventsub.EventSubTransportMethod;
import com.morelaid.streamingmodule.external.twitch4j.eventsub.condition.EventSubCondition;
import com.morelaid.streamingmodule.external.twitch4j.eventsub.events.EventSubEvent;
import com.morelaid.streamingmodule.external.twitch4j.eventsub.subscriptions.SubscriptionType;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

public interface IEventSubSocket
extends AutoCloseable {
    public IEventManager getEventManager();

    public OAuth2Credential getDefaultToken();

    public void connect();

    public void disconnect();

    public void reconnect();

    public Collection<EventSubSubscription> getSubscriptions();

    public boolean register(OAuth2Credential var1, EventSubSubscription var2);

    public boolean unregister(EventSubSubscription var1);

    public long getLatency();

    default public boolean register(EventSubSubscription sub) {
        return this.register(this.getDefaultToken(), sub);
    }

    default public <C extends EventSubCondition, B, E extends EventSubEvent> boolean register(SubscriptionType<C, B, E> type, Function<B, C> conditions) {
        return this.register(type.prepareSubscription(conditions, EventSubTransport.builder().method(EventSubTransportMethod.WEBSOCKET).sessionId("").build()));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    default public <C extends EventSubCondition, B, E extends EventSubEvent> boolean register(SubscriptionType<C, B, E> type, C condition) {
        return this.register(type, (C)((Object)((Function<Object, EventSubCondition>)b -> condition)));
    }
}

