/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.extensions.util;

import com.morelaid.streamingmodule.external.jackson.databind.ObjectMapper;
import com.morelaid.streamingmodule.external.twitch4j.common.exception.NotFoundException;
import com.morelaid.streamingmodule.external.twitch4j.common.exception.UnauthorizedException;
import com.morelaid.streamingmodule.external.twitch4j.extensions.domain.TwitchExtensionsError;
import feign.Request;
import feign.Response;
import feign.RetryableException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class TwitchExtensionsErrorDecoder
implements ErrorDecoder {
    private final ObjectMapper objectMapper;
    private final Decoder decoder;
    private final ErrorDecoder defaultDecoder = new ErrorDecoder.Default();

    @Override
    public Exception decode(String methodKey, Response response) {
        Exception ex;
        try (InputStream is = response.body() == null ? null : response.body().asInputStream();){
            String responseBody;
            String string = responseBody = is == null ? "" : IOUtils.toString(is, StandardCharsets.UTF_8);
            if (response.status() == 401) {
                ex = new UnauthorizedException().addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody);
            } else if (response.status() == 404) {
                ex = new NotFoundException().addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody);
            } else if (response.status() == 429) {
                ex = new ContextedRuntimeException("Too many requests!").addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody);
            } else if (response.status() == 503) {
                ex = new RetryableException(response.status(), "getting service unavailable, retrying ...", Request.HttpMethod.GET, (Long)null, response.request());
            } else {
                TwitchExtensionsError error = this.objectMapper.readValue(responseBody, TwitchExtensionsError.class);
                ex = new ContextedRuntimeException("Extensions API Error").addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody).addContextValue("errorType", error.getError()).addContextValue("errorStatus", error.getStatus()).addContextValue("errorType", error.getMessage()).addContextValue("errorMessage", error.getMessage());
            }
        }
        catch (IOException fallbackToDefault) {
            ex = this.defaultDecoder.decode(methodKey, response);
        }
        return ex;
    }

    @Generated
    public TwitchExtensionsErrorDecoder(ObjectMapper objectMapper, Decoder decoder) {
        this.objectMapper = objectMapper;
        this.decoder = decoder;
    }
}

