/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.morelaid.streamingmodule.external.twitch4j.graphql.internal.type.CustomType;
import com.morelaid.streamingmodule.external.twitch4j.graphql.internal.type.PredictionEventStatus;
import com.morelaid.streamingmodule.external.twitch4j.graphql.internal.type.PredictionOutcomeColor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchActivePredictionsQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "b15d5f0eea939431bba4b65a0fb2bceb9c66d213ad72af1ac1573daba4fa0c1d";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify("query fetchActivePredictions($channelId: ID!) {\n  channel(id: $channelId) {\n    __typename\n    activePredictionEvents {\n      __typename\n      createdAt\n      createdBy {\n        __typename\n        ... on User {\n          id\n          displayName\n          login\n        }\n      }\n      id\n      outcomes {\n        __typename\n        color\n        id\n        title\n        topPredictors {\n          __typename\n          id\n          points\n          predictedAt\n          updatedAt\n          user {\n            __typename\n            id\n            displayName\n            login\n          }\n        }\n        totalPoints\n        totalUsers\n      }\n      predictionWindowSeconds\n      status\n      title\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        @Override
        public String name() {
            return "fetchActivePredictions";
        }
    };
    private final Variables variables;

    public FetchActivePredictionsQuery(@NotNull String channelId) {
        Utils.checkNotNull(channelId, "channelId == null");
        this.variables = new Variables(channelId);
    }

    @Override
    public String operationId() {
        return OPERATION_ID;
    }

    @Override
    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    @Override
    public Data wrapData(Data data) {
        return data;
    }

    @Override
    public Variables variables() {
        return this.variables;
    }

    @Override
    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public OperationName name() {
        return OPERATION_NAME;
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source2, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse(source2, this, scalarTypeAdapters);
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse(new Buffer().write(byteString), scalarTypeAdapters);
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source2) throws IOException {
        return this.parse(source2, ScalarTypeAdapters.DEFAULT);
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @Override
    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose(this, false, true, scalarTypeAdapters);
    }

    @Override
    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose(this, false, true, ScalarTypeAdapters.DEFAULT);
    }

    @Override
    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose(this, autoPersistQueries, withQueryDocument, scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String channelId;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String channelId) {
            this.channelId = channelId;
            this.valueMap.put("channelId", channelId);
        }

        @NotNull
        public String channelId() {
            return this.channelId;
        }

        @Override
        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        @Override
        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                @Override
                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeCustom("channelId", CustomType.ID, channelId);
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject("channel", "channel", new UnmodifiableMapBuilder<String, Map<String, String>>(1).put("id", new UnmodifiableMapBuilder<String, String>(2).put("kind", "Variable").put("variableName", "channelId").build()).build(), true, Collections.emptyList())};
        @Nullable
        final Channel channel;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable Channel channel) {
            this.channel = channel;
        }

        @Nullable
        public Channel channel() {
            return this.channel;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], channel != null ? channel.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{channel=" + this.channel + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.channel == null ? that.channel == null : this.channel.equals(that.channel);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.channel == null ? 0 : this.channel.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final Channel.Mapper channelFieldMapper = new Channel.Mapper();

            @Override
            public Data map(ResponseReader reader) {
                Channel channel = reader.readObject($responseFields[0], new ResponseReader.ObjectReader<Channel>(){

                    @Override
                    public Channel read(ResponseReader reader) {
                        return channelFieldMapper.map(reader);
                    }
                });
                return new Data(channel);
            }
        }
    }

    public static final class Builder {
        @NotNull
        private String channelId;

        Builder() {
        }

        public Builder channelId(@NotNull String channelId) {
            this.channelId = channelId;
            return this;
        }

        public FetchActivePredictionsQuery build() {
            Utils.checkNotNull(this.channelId, "channelId == null");
            return new FetchActivePredictionsQuery(this.channelId);
        }
    }

    public static class User {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("displayName", "displayName", null, false, Collections.emptyList()), ResponseField.forString("login", "login", null, false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String displayName;
        @NotNull
        final String login;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User(@NotNull String __typename, @NotNull String id, @NotNull String displayName, @NotNull String login) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.displayName = Utils.checkNotNull(displayName, "displayName == null");
            this.login = Utils.checkNotNull(login, "login == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                    writer.writeString($responseFields[2], displayName);
                    writer.writeString($responseFields[3], login);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User{__typename=" + this.__typename + ", id=" + this.id + ", displayName=" + this.displayName + ", login=" + this.login + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User) {
                User that = (User)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.displayName.equals(that.displayName) && this.login.equals(that.login);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.displayName.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.login.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User> {
            @Override
            public User map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String displayName = reader.readString($responseFields[2]);
                String login = reader.readString($responseFields[3]);
                return new User(__typename, id, displayName, login);
            }
        }
    }

    public static class TopPredictor {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forInt("points", "points", null, false, Collections.emptyList()), ResponseField.forCustomType("predictedAt", "predictedAt", null, false, CustomType.TIME, Collections.emptyList()), ResponseField.forCustomType("updatedAt", "updatedAt", null, false, CustomType.TIME, Collections.emptyList()), ResponseField.forObject("user", "user", null, true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        final int points;
        @NotNull
        final Object predictedAt;
        @NotNull
        final Object updatedAt;
        @Nullable
        final User user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public TopPredictor(@NotNull String __typename, @NotNull String id, int points, @NotNull Object predictedAt, @NotNull Object updatedAt, @Nullable User user) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.points = points;
            this.predictedAt = Utils.checkNotNull(predictedAt, "predictedAt == null");
            this.updatedAt = Utils.checkNotNull(updatedAt, "updatedAt == null");
            this.user = user;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        public int points() {
            return this.points;
        }

        @NotNull
        public Object predictedAt() {
            return this.predictedAt;
        }

        @NotNull
        public Object updatedAt() {
            return this.updatedAt;
        }

        @Nullable
        public User user() {
            return this.user;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                    writer.writeInt($responseFields[2], points);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[3], predictedAt);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[4], updatedAt);
                    writer.writeObject($responseFields[5], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "TopPredictor{__typename=" + this.__typename + ", id=" + this.id + ", points=" + this.points + ", predictedAt=" + this.predictedAt + ", updatedAt=" + this.updatedAt + ", user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TopPredictor) {
                TopPredictor that = (TopPredictor)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.points == that.points && this.predictedAt.equals(that.predictedAt) && this.updatedAt.equals(that.updatedAt) && (this.user == null ? that.user == null : this.user.equals(that.user));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.points;
                h2 *= 1000003;
                h2 ^= this.predictedAt.hashCode();
                h2 *= 1000003;
                h2 ^= this.updatedAt.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<TopPredictor> {
            final User.Mapper userFieldMapper = new User.Mapper();

            @Override
            public TopPredictor map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                int points = reader.readInt($responseFields[2]);
                Object predictedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[3]);
                Object updatedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[4]);
                User user = reader.readObject($responseFields[5], new ResponseReader.ObjectReader<User>(){

                    @Override
                    public User read(ResponseReader reader) {
                        return userFieldMapper.map(reader);
                    }
                });
                return new TopPredictor(__typename, id, points, predictedAt, updatedAt, user);
            }
        }
    }

    public static class Outcome {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forString("color", "color", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("title", "title", null, false, Collections.emptyList()), ResponseField.forList("topPredictors", "topPredictors", null, false, Collections.emptyList()), ResponseField.forInt("totalPoints", "totalPoints", null, false, Collections.emptyList()), ResponseField.forInt("totalUsers", "totalUsers", null, false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final PredictionOutcomeColor color;
        @NotNull
        final String id;
        @NotNull
        final String title;
        @NotNull
        final List<TopPredictor> topPredictors;
        final int totalPoints;
        final int totalUsers;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Outcome(@NotNull String __typename, @NotNull PredictionOutcomeColor color, @NotNull String id, @NotNull String title, @NotNull List<TopPredictor> topPredictors, int totalPoints, int totalUsers) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.color = Utils.checkNotNull(color, "color == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.title = Utils.checkNotNull(title, "title == null");
            this.topPredictors = Utils.checkNotNull(topPredictors, "topPredictors == null");
            this.totalPoints = totalPoints;
            this.totalUsers = totalUsers;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public PredictionOutcomeColor color() {
            return this.color;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String title() {
            return this.title;
        }

        @NotNull
        public List<TopPredictor> topPredictors() {
            return this.topPredictors;
        }

        public int totalPoints() {
            return this.totalPoints;
        }

        public int totalUsers() {
            return this.totalUsers;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], color.rawValue());
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], id);
                    writer.writeString($responseFields[3], title);
                    writer.writeList($responseFields[4], topPredictors, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((TopPredictor)item).marshaller());
                            }
                        }
                    });
                    writer.writeInt($responseFields[5], totalPoints);
                    writer.writeInt($responseFields[6], totalUsers);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Outcome{__typename=" + this.__typename + ", color=" + (Object)((Object)this.color) + ", id=" + this.id + ", title=" + this.title + ", topPredictors=" + this.topPredictors + ", totalPoints=" + this.totalPoints + ", totalUsers=" + this.totalUsers + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Outcome) {
                Outcome that = (Outcome)o;
                return this.__typename.equals(that.__typename) && this.color.equals((Object)that.color) && this.id.equals(that.id) && this.title.equals(that.title) && this.topPredictors.equals(that.topPredictors) && this.totalPoints == that.totalPoints && this.totalUsers == that.totalUsers;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.color.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.title.hashCode();
                h2 *= 1000003;
                h2 ^= this.topPredictors.hashCode();
                h2 *= 1000003;
                h2 ^= this.totalPoints;
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.totalUsers;
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Outcome> {
            final TopPredictor.Mapper topPredictorFieldMapper = new TopPredictor.Mapper();

            @Override
            public Outcome map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String colorStr = reader.readString($responseFields[1]);
                PredictionOutcomeColor color = colorStr != null ? PredictionOutcomeColor.safeValueOf(colorStr) : null;
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                String title = reader.readString($responseFields[3]);
                List<TopPredictor> topPredictors = reader.readList($responseFields[4], new ResponseReader.ListReader<TopPredictor>(){

                    @Override
                    public TopPredictor read(ResponseReader.ListItemReader listItemReader) {
                        return listItemReader.readObject(new ResponseReader.ObjectReader<TopPredictor>(){

                            @Override
                            public TopPredictor read(ResponseReader reader) {
                                return topPredictorFieldMapper.map(reader);
                            }
                        });
                    }
                });
                int totalPoints = reader.readInt($responseFields[5]);
                int totalUsers = reader.readInt($responseFields[6]);
                return new Outcome(__typename, color, id, title, topPredictors, totalPoints, totalUsers);
            }
        }
    }

    public static class AsPredictionEventActor
    implements CreatedBy {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList())};
        @NotNull
        final String __typename;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsPredictionEventActor(@NotNull String __typename) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsPredictionEventActor{__typename=" + this.__typename + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsPredictionEventActor) {
                AsPredictionEventActor that = (AsPredictionEventActor)o;
                return this.__typename.equals(that.__typename);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.__typename.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsPredictionEventActor> {
            @Override
            public AsPredictionEventActor map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                return new AsPredictionEventActor(__typename);
            }
        }
    }

    public static class AsUser
    implements CreatedBy {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("displayName", "displayName", null, false, Collections.emptyList()), ResponseField.forString("login", "login", null, false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String displayName;
        @NotNull
        final String login;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsUser(@NotNull String __typename, @NotNull String id, @NotNull String displayName, @NotNull String login) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.displayName = Utils.checkNotNull(displayName, "displayName == null");
            this.login = Utils.checkNotNull(login, "login == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                    writer.writeString($responseFields[2], displayName);
                    writer.writeString($responseFields[3], login);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsUser{__typename=" + this.__typename + ", id=" + this.id + ", displayName=" + this.displayName + ", login=" + this.login + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsUser) {
                AsUser that = (AsUser)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.displayName.equals(that.displayName) && this.login.equals(that.login);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.displayName.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.login.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsUser> {
            @Override
            public AsUser map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String displayName = reader.readString($responseFields[2]);
                String login = reader.readString($responseFields[3]);
                return new AsUser(__typename, id, displayName, login);
            }
        }
    }

    public static interface CreatedBy {
        @NotNull
        public String __typename();

        public ResponseFieldMarshaller marshaller();

        public static final class Mapper
        implements ResponseFieldMapper<CreatedBy> {
            static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forFragment("__typename", "__typename", Arrays.asList(ResponseField.Condition.typeCondition(new String[]{"User"})))};
            final AsUser.Mapper asUserFieldMapper = new AsUser.Mapper();
            final AsPredictionEventActor.Mapper asPredictionEventActorFieldMapper = new AsPredictionEventActor.Mapper();

            @Override
            public CreatedBy map(ResponseReader reader) {
                AsUser asUser = reader.readFragment($responseFields[0], new ResponseReader.ObjectReader<AsUser>(){

                    @Override
                    public AsUser read(ResponseReader reader) {
                        return asUserFieldMapper.map(reader);
                    }
                });
                if (asUser != null) {
                    return asUser;
                }
                return this.asPredictionEventActorFieldMapper.map(reader);
            }
        }
    }

    public static class ActivePredictionEvent {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("createdAt", "createdAt", null, false, CustomType.TIME, Collections.emptyList()), ResponseField.forObject("createdBy", "createdBy", null, true, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forList("outcomes", "outcomes", null, false, Collections.emptyList()), ResponseField.forInt("predictionWindowSeconds", "predictionWindowSeconds", null, false, Collections.emptyList()), ResponseField.forString("status", "status", null, false, Collections.emptyList()), ResponseField.forString("title", "title", null, false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Object createdAt;
        @Nullable
        final CreatedBy createdBy;
        @NotNull
        final String id;
        @NotNull
        final List<Outcome> outcomes;
        final int predictionWindowSeconds;
        @NotNull
        final PredictionEventStatus status;
        @NotNull
        final String title;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public ActivePredictionEvent(@NotNull String __typename, @NotNull Object createdAt, @Nullable CreatedBy createdBy, @NotNull String id, @NotNull List<Outcome> outcomes, int predictionWindowSeconds, @NotNull PredictionEventStatus status, @NotNull String title) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.createdAt = Utils.checkNotNull(createdAt, "createdAt == null");
            this.createdBy = createdBy;
            this.id = Utils.checkNotNull(id, "id == null");
            this.outcomes = Utils.checkNotNull(outcomes, "outcomes == null");
            this.predictionWindowSeconds = predictionWindowSeconds;
            this.status = Utils.checkNotNull(status, "status == null");
            this.title = Utils.checkNotNull(title, "title == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public Object createdAt() {
            return this.createdAt;
        }

        @Nullable
        public CreatedBy createdBy() {
            return this.createdBy;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public List<Outcome> outcomes() {
            return this.outcomes;
        }

        public int predictionWindowSeconds() {
            return this.predictionWindowSeconds;
        }

        @NotNull
        public PredictionEventStatus status() {
            return this.status;
        }

        @NotNull
        public String title() {
            return this.title;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], createdAt);
                    writer.writeObject($responseFields[2], createdBy != null ? createdBy.marshaller() : null);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[3], id);
                    writer.writeList($responseFields[4], outcomes, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Outcome)item).marshaller());
                            }
                        }
                    });
                    writer.writeInt($responseFields[5], predictionWindowSeconds);
                    writer.writeString($responseFields[6], status.rawValue());
                    writer.writeString($responseFields[7], title);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "ActivePredictionEvent{__typename=" + this.__typename + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", id=" + this.id + ", outcomes=" + this.outcomes + ", predictionWindowSeconds=" + this.predictionWindowSeconds + ", status=" + (Object)((Object)this.status) + ", title=" + this.title + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ActivePredictionEvent) {
                ActivePredictionEvent that = (ActivePredictionEvent)o;
                return this.__typename.equals(that.__typename) && this.createdAt.equals(that.createdAt) && (this.createdBy == null ? that.createdBy == null : this.createdBy.equals(that.createdBy)) && this.id.equals(that.id) && this.outcomes.equals(that.outcomes) && this.predictionWindowSeconds == that.predictionWindowSeconds && this.status.equals((Object)that.status) && this.title.equals(that.title);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.createdAt.hashCode();
                h2 *= 1000003;
                h2 ^= this.createdBy == null ? 0 : this.createdBy.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.outcomes.hashCode();
                h2 *= 1000003;
                h2 ^= this.predictionWindowSeconds;
                h2 *= 1000003;
                h2 ^= this.status.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.title.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<ActivePredictionEvent> {
            final CreatedBy.Mapper createdByFieldMapper = new CreatedBy.Mapper();
            final Outcome.Mapper outcomeFieldMapper = new Outcome.Mapper();

            @Override
            public ActivePredictionEvent map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object createdAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                CreatedBy createdBy = reader.readObject($responseFields[2], new ResponseReader.ObjectReader<CreatedBy>(){

                    @Override
                    public CreatedBy read(ResponseReader reader) {
                        return createdByFieldMapper.map(reader);
                    }
                });
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[3]);
                List<Outcome> outcomes = reader.readList($responseFields[4], new ResponseReader.ListReader<Outcome>(){

                    @Override
                    public Outcome read(ResponseReader.ListItemReader listItemReader) {
                        return listItemReader.readObject(new ResponseReader.ObjectReader<Outcome>(){

                            @Override
                            public Outcome read(ResponseReader reader) {
                                return outcomeFieldMapper.map(reader);
                            }
                        });
                    }
                });
                int predictionWindowSeconds = reader.readInt($responseFields[5]);
                String statusStr = reader.readString($responseFields[6]);
                PredictionEventStatus status = statusStr != null ? PredictionEventStatus.safeValueOf(statusStr) : null;
                String title = reader.readString($responseFields[7]);
                return new ActivePredictionEvent(__typename, createdAt, createdBy, id, outcomes, predictionWindowSeconds, status, title);
            }
        }
    }

    public static class Channel {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forList("activePredictionEvents", "activePredictionEvents", null, true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final List<ActivePredictionEvent> activePredictionEvents;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Channel(@NotNull String __typename, @Nullable List<ActivePredictionEvent> activePredictionEvents) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.activePredictionEvents = activePredictionEvents;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public List<ActivePredictionEvent> activePredictionEvents() {
            return this.activePredictionEvents;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], activePredictionEvents, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((ActivePredictionEvent)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Channel{__typename=" + this.__typename + ", activePredictionEvents=" + this.activePredictionEvents + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Channel) {
                Channel that = (Channel)o;
                return this.__typename.equals(that.__typename) && (this.activePredictionEvents == null ? that.activePredictionEvents == null : this.activePredictionEvents.equals(that.activePredictionEvents));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.activePredictionEvents == null ? 0 : this.activePredictionEvents.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Channel> {
            final ActivePredictionEvent.Mapper activePredictionEventFieldMapper = new ActivePredictionEvent.Mapper();

            @Override
            public Channel map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List<ActivePredictionEvent> activePredictionEvents = reader.readList($responseFields[1], new ResponseReader.ListReader<ActivePredictionEvent>(){

                    @Override
                    public ActivePredictionEvent read(ResponseReader.ListItemReader listItemReader) {
                        return listItemReader.readObject(new ResponseReader.ObjectReader<ActivePredictionEvent>(){

                            @Override
                            public ActivePredictionEvent read(ResponseReader reader) {
                                return activePredictionEventFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new Channel(__typename, activePredictionEvents);
            }
        }
    }
}

