/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.morelaid.streamingmodule.external.twitch4j.graphql.internal.type.CustomType;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchUserQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "e0c653e6aba7c345345fa75c9d7c7bdb9376aa19b42d99f3c67304284d15a318";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify("query fetchUser($id: ID, $login: String) {\n  user(id: $id, login: $login, lookupType: ALL) {\n    __typename\n    id\n    login\n    displayName\n    description\n    profileImageURL(width: 50)\n    profileViewCount\n    primaryColorHex\n    createdAt\n    updatedAt\n    broadcastSettings {\n      __typename\n      id\n      title\n      game {\n        __typename\n        id\n        displayName\n      }\n    }\n    stream {\n      __typename\n      id\n      previewImageURL\n    }\n    followers {\n      __typename\n      totalCount\n    }\n    roles {\n      __typename\n      isAffiliate\n      isPartner\n      isStaff\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        @Override
        public String name() {
            return "fetchUser";
        }
    };
    private final Variables variables;

    public FetchUserQuery(@NotNull Input<String> id, @NotNull Input<String> login) {
        Utils.checkNotNull(id, "id == null");
        Utils.checkNotNull(login, "login == null");
        this.variables = new Variables(id, login);
    }

    @Override
    public String operationId() {
        return OPERATION_ID;
    }

    @Override
    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    @Override
    public Data wrapData(Data data) {
        return data;
    }

    @Override
    public Variables variables() {
        return this.variables;
    }

    @Override
    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public OperationName name() {
        return OPERATION_NAME;
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source2, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse(source2, this, scalarTypeAdapters);
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse(new Buffer().write(byteString), scalarTypeAdapters);
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source2) throws IOException {
        return this.parse(source2, ScalarTypeAdapters.DEFAULT);
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @Override
    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose(this, false, true, scalarTypeAdapters);
    }

    @Override
    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose(this, false, true, ScalarTypeAdapters.DEFAULT);
    }

    @Override
    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose(this, autoPersistQueries, withQueryDocument, scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        private final Input<String> id;
        private final Input<String> login;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(Input<String> id, Input<String> login) {
            this.id = id;
            this.login = login;
            if (id.defined) {
                this.valueMap.put("id", id.value);
            }
            if (login.defined) {
                this.valueMap.put("login", login.value);
            }
        }

        public Input<String> id() {
            return this.id;
        }

        public Input<String> login() {
            return this.login;
        }

        @Override
        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        @Override
        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                @Override
                public void marshal(InputFieldWriter writer) throws IOException {
                    if (((Variables)this).id.defined) {
                        writer.writeCustom("id", CustomType.ID, ((Variables)this).id.value != null ? ((Variables)this).id.value : null);
                    }
                    if (((Variables)this).login.defined) {
                        writer.writeString("login", (String)((Variables)this).login.value);
                    }
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject("user", "user", new UnmodifiableMapBuilder<String, Map<String, String>>(3).put("id", new UnmodifiableMapBuilder<String, String>(2).put("kind", "Variable").put("variableName", "id").build()).put("login", new UnmodifiableMapBuilder<String, String>(2).put("kind", "Variable").put("variableName", "login").build()).put("lookupType", (Map<String, String>)((Object)"ALL")).build(), true, Collections.emptyList())};
        @Nullable
        final User user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable User user) {
            this.user = user;
        }

        @Nullable
        public User user() {
            return this.user;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.user == null ? that.user == null : this.user.equals(that.user);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final User.Mapper userFieldMapper = new User.Mapper();

            @Override
            public Data map(ResponseReader reader) {
                User user = reader.readObject($responseFields[0], new ResponseReader.ObjectReader<User>(){

                    @Override
                    public User read(ResponseReader reader) {
                        return userFieldMapper.map(reader);
                    }
                });
                return new Data(user);
            }
        }
    }

    public static final class Builder {
        private Input<String> id = Input.absent();
        private Input<String> login = Input.absent();

        Builder() {
        }

        public Builder id(@Nullable String id) {
            this.id = Input.fromNullable(id);
            return this;
        }

        public Builder login(@Nullable String login) {
            this.login = Input.fromNullable(login);
            return this;
        }

        public Builder idInput(@NotNull Input<String> id) {
            this.id = Utils.checkNotNull(id, "id == null");
            return this;
        }

        public Builder loginInput(@NotNull Input<String> login) {
            this.login = Utils.checkNotNull(login, "login == null");
            return this;
        }

        public FetchUserQuery build() {
            return new FetchUserQuery(this.id, this.login);
        }
    }

    public static class Roles {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forBoolean("isAffiliate", "isAffiliate", null, true, Collections.emptyList()), ResponseField.forBoolean("isPartner", "isPartner", null, true, Collections.emptyList()), ResponseField.forBoolean("isStaff", "isStaff", null, true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final Boolean isAffiliate;
        @Nullable
        final Boolean isPartner;
        @Nullable
        final Boolean isStaff;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Roles(@NotNull String __typename, @Nullable Boolean isAffiliate, @Nullable Boolean isPartner, @Nullable Boolean isStaff) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.isAffiliate = isAffiliate;
            this.isPartner = isPartner;
            this.isStaff = isStaff;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public Boolean isAffiliate() {
            return this.isAffiliate;
        }

        @Nullable
        public Boolean isPartner() {
            return this.isPartner;
        }

        @Nullable
        public Boolean isStaff() {
            return this.isStaff;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeBoolean($responseFields[1], isAffiliate);
                    writer.writeBoolean($responseFields[2], isPartner);
                    writer.writeBoolean($responseFields[3], isStaff);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Roles{__typename=" + this.__typename + ", isAffiliate=" + this.isAffiliate + ", isPartner=" + this.isPartner + ", isStaff=" + this.isStaff + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Roles) {
                Roles that = (Roles)o;
                return this.__typename.equals(that.__typename) && (this.isAffiliate == null ? that.isAffiliate == null : this.isAffiliate.equals(that.isAffiliate)) && (this.isPartner == null ? that.isPartner == null : this.isPartner.equals(that.isPartner)) && (this.isStaff == null ? that.isStaff == null : this.isStaff.equals(that.isStaff));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.isAffiliate == null ? 0 : this.isAffiliate.hashCode();
                h2 *= 1000003;
                h2 ^= this.isPartner == null ? 0 : this.isPartner.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.isStaff == null ? 0 : this.isStaff.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Roles> {
            @Override
            public Roles map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Boolean isAffiliate = reader.readBoolean($responseFields[1]);
                Boolean isPartner = reader.readBoolean($responseFields[2]);
                Boolean isStaff = reader.readBoolean($responseFields[3]);
                return new Roles(__typename, isAffiliate, isPartner, isStaff);
            }
        }
    }

    public static class Followers {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forInt("totalCount", "totalCount", null, true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final Integer totalCount;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Followers(@NotNull String __typename, @Nullable Integer totalCount) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.totalCount = totalCount;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public Integer totalCount() {
            return this.totalCount;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeInt($responseFields[1], totalCount);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Followers{__typename=" + this.__typename + ", totalCount=" + this.totalCount + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Followers) {
                Followers that = (Followers)o;
                return this.__typename.equals(that.__typename) && (this.totalCount == null ? that.totalCount == null : this.totalCount.equals(that.totalCount));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.totalCount == null ? 0 : this.totalCount.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Followers> {
            @Override
            public Followers map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Integer totalCount = reader.readInt($responseFields[1]);
                return new Followers(__typename, totalCount);
            }
        }
    }

    public static class Stream {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("previewImageURL", "previewImageURL", null, true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @Nullable
        final String previewImageURL;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Stream(@NotNull String __typename, @NotNull String id, @Nullable String previewImageURL) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.previewImageURL = previewImageURL;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public String previewImageURL() {
            return this.previewImageURL;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                    writer.writeString($responseFields[2], previewImageURL);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Stream{__typename=" + this.__typename + ", id=" + this.id + ", previewImageURL=" + this.previewImageURL + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Stream) {
                Stream that = (Stream)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && (this.previewImageURL == null ? that.previewImageURL == null : this.previewImageURL.equals(that.previewImageURL));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.previewImageURL == null ? 0 : this.previewImageURL.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Stream> {
            @Override
            public Stream map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String previewImageURL = reader.readString($responseFields[2]);
                return new Stream(__typename, id, previewImageURL);
            }
        }
    }

    public static class Game {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("displayName", "displayName", null, false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String displayName;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Game(@NotNull String __typename, @NotNull String id, @NotNull String displayName) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.displayName = Utils.checkNotNull(displayName, "displayName == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                    writer.writeString($responseFields[2], displayName);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Game{__typename=" + this.__typename + ", id=" + this.id + ", displayName=" + this.displayName + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Game) {
                Game that = (Game)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.displayName.equals(that.displayName);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.displayName.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Game> {
            @Override
            public Game map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String displayName = reader.readString($responseFields[2]);
                return new Game(__typename, id, displayName);
            }
        }
    }

    public static class BroadcastSettings {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("title", "title", null, false, Collections.emptyList()), ResponseField.forObject("game", "game", null, true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String title;
        @Nullable
        final Game game;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public BroadcastSettings(@NotNull String __typename, @NotNull String id, @NotNull String title, @Nullable Game game) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.title = Utils.checkNotNull(title, "title == null");
            this.game = game;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String title() {
            return this.title;
        }

        @Nullable
        public Game game() {
            return this.game;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                    writer.writeString($responseFields[2], title);
                    writer.writeObject($responseFields[3], game != null ? game.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "BroadcastSettings{__typename=" + this.__typename + ", id=" + this.id + ", title=" + this.title + ", game=" + this.game + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof BroadcastSettings) {
                BroadcastSettings that = (BroadcastSettings)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.title.equals(that.title) && (this.game == null ? that.game == null : this.game.equals(that.game));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.title.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.game == null ? 0 : this.game.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<BroadcastSettings> {
            final Game.Mapper gameFieldMapper = new Game.Mapper();

            @Override
            public BroadcastSettings map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String title = reader.readString($responseFields[2]);
                Game game = reader.readObject($responseFields[3], new ResponseReader.ObjectReader<Game>(){

                    @Override
                    public Game read(ResponseReader reader) {
                        return gameFieldMapper.map(reader);
                    }
                });
                return new BroadcastSettings(__typename, id, title, game);
            }
        }
    }

    public static class User {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("login", "login", null, false, Collections.emptyList()), ResponseField.forString("displayName", "displayName", null, false, Collections.emptyList()), ResponseField.forString("description", "description", null, true, Collections.emptyList()), ResponseField.forString("profileImageURL", "profileImageURL", new UnmodifiableMapBuilder<String, Integer>(1).put("width", 50).build(), true, Collections.emptyList()), ResponseField.forInt("profileViewCount", "profileViewCount", null, true, Collections.emptyList()), ResponseField.forString("primaryColorHex", "primaryColorHex", null, true, Collections.emptyList()), ResponseField.forCustomType("createdAt", "createdAt", null, false, CustomType.TIME, Collections.emptyList()), ResponseField.forCustomType("updatedAt", "updatedAt", null, true, CustomType.TIME, Collections.emptyList()), ResponseField.forObject("broadcastSettings", "broadcastSettings", null, true, Collections.emptyList()), ResponseField.forObject("stream", "stream", null, true, Collections.emptyList()), ResponseField.forObject("followers", "followers", null, true, Collections.emptyList()), ResponseField.forObject("roles", "roles", null, true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        @Nullable
        final String description;
        @Nullable
        final String profileImageURL;
        @Nullable
        final Integer profileViewCount;
        @Nullable
        final String primaryColorHex;
        @NotNull
        final Object createdAt;
        @Nullable
        final Object updatedAt;
        @Nullable
        final BroadcastSettings broadcastSettings;
        @Nullable
        final Stream stream;
        @Nullable
        final Followers followers;
        @Nullable
        final Roles roles;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName, @Nullable String description, @Nullable String profileImageURL, @Nullable Integer profileViewCount, @Nullable String primaryColorHex, @NotNull Object createdAt, @Nullable Object updatedAt, @Nullable BroadcastSettings broadcastSettings, @Nullable Stream stream, @Nullable Followers followers, @Nullable Roles roles) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.login = Utils.checkNotNull(login, "login == null");
            this.displayName = Utils.checkNotNull(displayName, "displayName == null");
            this.description = description;
            this.profileImageURL = profileImageURL;
            this.profileViewCount = profileViewCount;
            this.primaryColorHex = primaryColorHex;
            this.createdAt = Utils.checkNotNull(createdAt, "createdAt == null");
            this.updatedAt = updatedAt;
            this.broadcastSettings = broadcastSettings;
            this.stream = stream;
            this.followers = followers;
            this.roles = roles;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @Nullable
        public String description() {
            return this.description;
        }

        @Nullable
        public String profileImageURL() {
            return this.profileImageURL;
        }

        @Nullable
        public Integer profileViewCount() {
            return this.profileViewCount;
        }

        @Nullable
        public String primaryColorHex() {
            return this.primaryColorHex;
        }

        @NotNull
        public Object createdAt() {
            return this.createdAt;
        }

        @Nullable
        public Object updatedAt() {
            return this.updatedAt;
        }

        @Nullable
        public BroadcastSettings broadcastSettings() {
            return this.broadcastSettings;
        }

        @Nullable
        public Stream stream() {
            return this.stream;
        }

        @Nullable
        public Followers followers() {
            return this.followers;
        }

        @Nullable
        public Roles roles() {
            return this.roles;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                    writer.writeString($responseFields[4], description);
                    writer.writeString($responseFields[5], profileImageURL);
                    writer.writeInt($responseFields[6], profileViewCount);
                    writer.writeString($responseFields[7], primaryColorHex);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[8], createdAt);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[9], updatedAt);
                    writer.writeObject($responseFields[10], broadcastSettings != null ? broadcastSettings.marshaller() : null);
                    writer.writeObject($responseFields[11], stream != null ? stream.marshaller() : null);
                    writer.writeObject($responseFields[12], followers != null ? followers.marshaller() : null);
                    writer.writeObject($responseFields[13], roles != null ? roles.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + ", description=" + this.description + ", profileImageURL=" + this.profileImageURL + ", profileViewCount=" + this.profileViewCount + ", primaryColorHex=" + this.primaryColorHex + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", broadcastSettings=" + this.broadcastSettings + ", stream=" + this.stream + ", followers=" + this.followers + ", roles=" + this.roles + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User) {
                User that = (User)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName) && (this.description == null ? that.description == null : this.description.equals(that.description)) && (this.profileImageURL == null ? that.profileImageURL == null : this.profileImageURL.equals(that.profileImageURL)) && (this.profileViewCount == null ? that.profileViewCount == null : this.profileViewCount.equals(that.profileViewCount)) && (this.primaryColorHex == null ? that.primaryColorHex == null : this.primaryColorHex.equals(that.primaryColorHex)) && this.createdAt.equals(that.createdAt) && (this.updatedAt == null ? that.updatedAt == null : this.updatedAt.equals(that.updatedAt)) && (this.broadcastSettings == null ? that.broadcastSettings == null : this.broadcastSettings.equals(that.broadcastSettings)) && (this.stream == null ? that.stream == null : this.stream.equals(that.stream)) && (this.followers == null ? that.followers == null : this.followers.equals(that.followers)) && (this.roles == null ? that.roles == null : this.roles.equals(that.roles));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.login.hashCode();
                h2 *= 1000003;
                h2 ^= this.displayName.hashCode();
                h2 *= 1000003;
                h2 ^= this.description == null ? 0 : this.description.hashCode();
                h2 *= 1000003;
                h2 ^= this.profileImageURL == null ? 0 : this.profileImageURL.hashCode();
                h2 *= 1000003;
                h2 ^= this.profileViewCount == null ? 0 : this.profileViewCount.hashCode();
                h2 *= 1000003;
                h2 ^= this.primaryColorHex == null ? 0 : this.primaryColorHex.hashCode();
                h2 *= 1000003;
                h2 ^= this.createdAt.hashCode();
                h2 *= 1000003;
                h2 ^= this.updatedAt == null ? 0 : this.updatedAt.hashCode();
                h2 *= 1000003;
                h2 ^= this.broadcastSettings == null ? 0 : this.broadcastSettings.hashCode();
                h2 *= 1000003;
                h2 ^= this.stream == null ? 0 : this.stream.hashCode();
                h2 *= 1000003;
                h2 ^= this.followers == null ? 0 : this.followers.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.roles == null ? 0 : this.roles.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User> {
            final BroadcastSettings.Mapper broadcastSettingsFieldMapper = new BroadcastSettings.Mapper();
            final Stream.Mapper streamFieldMapper = new Stream.Mapper();
            final Followers.Mapper followersFieldMapper = new Followers.Mapper();
            final Roles.Mapper rolesFieldMapper = new Roles.Mapper();

            @Override
            public User map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                String description = reader.readString($responseFields[4]);
                String profileImageURL = reader.readString($responseFields[5]);
                Integer profileViewCount = reader.readInt($responseFields[6]);
                String primaryColorHex = reader.readString($responseFields[7]);
                Object createdAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[8]);
                Object updatedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[9]);
                BroadcastSettings broadcastSettings = reader.readObject($responseFields[10], new ResponseReader.ObjectReader<BroadcastSettings>(){

                    @Override
                    public BroadcastSettings read(ResponseReader reader) {
                        return broadcastSettingsFieldMapper.map(reader);
                    }
                });
                Stream stream = reader.readObject($responseFields[11], new ResponseReader.ObjectReader<Stream>(){

                    @Override
                    public Stream read(ResponseReader reader) {
                        return streamFieldMapper.map(reader);
                    }
                });
                Followers followers = reader.readObject($responseFields[12], new ResponseReader.ObjectReader<Followers>(){

                    @Override
                    public Followers read(ResponseReader reader) {
                        return followersFieldMapper.map(reader);
                    }
                });
                Roles roles = reader.readObject($responseFields[13], new ResponseReader.ObjectReader<Roles>(){

                    @Override
                    public Roles read(ResponseReader reader) {
                        return rolesFieldMapper.map(reader);
                    }
                });
                return new User(__typename, id, login, displayName, description, profileImageURL, profileViewCount, primaryColorHex, createdAt, updatedAt, broadcastSettings, stream, followers, roles);
            }
        }
    }
}

