/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.morelaid.streamingmodule.external.twitch4j.graphql.internal.type.CustomType;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchUserSubscriptionsQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "5ae9efd9b1d10af3286bf6f780f5a8c7bbc19ce99b04603f24457807cef65353";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify("query fetchUserSubscriptions($id: ID!, $first: Int = 75, $after: Cursor) {\n  user(id: $id) {\n    __typename\n    subscriptionBenefits(first: $first, after: $after, criteria: {filter: ALL}) {\n      __typename\n      edges {\n        __typename\n        cursor\n        node {\n          __typename\n          endsAt\n          gift {\n            __typename\n            giftDate\n            gifter {\n              __typename\n              id\n              login\n              displayName\n              profileImageURL(width: 50)\n            }\n            isGift\n          }\n          id\n          product {\n            __typename\n            displayName\n            id\n            name\n            emoteGroups(state: ACTIVE) {\n              __typename\n              id\n            }\n          }\n          purchasedWithPrime\n          renewsAt\n          tier\n          user {\n            __typename\n            id\n            login\n            displayName\n            profileImageURL(width: 50)\n          }\n        }\n      }\n      pageInfo {\n        __typename\n        hasNextPage\n      }\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        @Override
        public String name() {
            return "fetchUserSubscriptions";
        }
    };
    private final Variables variables;

    public FetchUserSubscriptionsQuery(@NotNull String id, @NotNull Input<Integer> first, @NotNull Input<Object> after) {
        Utils.checkNotNull(id, "id == null");
        Utils.checkNotNull(first, "first == null");
        Utils.checkNotNull(after, "after == null");
        this.variables = new Variables(id, first, after);
    }

    @Override
    public String operationId() {
        return OPERATION_ID;
    }

    @Override
    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    @Override
    public Data wrapData(Data data) {
        return data;
    }

    @Override
    public Variables variables() {
        return this.variables;
    }

    @Override
    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public OperationName name() {
        return OPERATION_NAME;
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source2, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse(source2, this, scalarTypeAdapters);
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse(new Buffer().write(byteString), scalarTypeAdapters);
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source2) throws IOException {
        return this.parse(source2, ScalarTypeAdapters.DEFAULT);
    }

    @Override
    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @Override
    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose(this, false, true, scalarTypeAdapters);
    }

    @Override
    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose(this, false, true, ScalarTypeAdapters.DEFAULT);
    }

    @Override
    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose(this, autoPersistQueries, withQueryDocument, scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String id;
        private final Input<Integer> first;
        private final Input<Object> after;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String id, Input<Integer> first, Input<Object> after) {
            this.id = id;
            this.first = first;
            this.after = after;
            this.valueMap.put("id", id);
            if (first.defined) {
                this.valueMap.put("first", first.value);
            }
            if (after.defined) {
                this.valueMap.put("after", after.value);
            }
        }

        @NotNull
        public String id() {
            return this.id;
        }

        public Input<Integer> first() {
            return this.first;
        }

        public Input<Object> after() {
            return this.after;
        }

        @Override
        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        @Override
        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                @Override
                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeCustom("id", CustomType.ID, id);
                    if (((Variables)this).first.defined) {
                        writer.writeInt("first", (Integer)((Variables)this).first.value);
                    }
                    if (((Variables)this).after.defined) {
                        writer.writeCustom("after", CustomType.CURSOR, ((Variables)this).after.value != null ? ((Variables)this).after.value : null);
                    }
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject("user", "user", new UnmodifiableMapBuilder<String, Map<String, String>>(1).put("id", new UnmodifiableMapBuilder<String, String>(2).put("kind", "Variable").put("variableName", "id").build()).build(), true, Collections.emptyList())};
        @Nullable
        final User user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable User user) {
            this.user = user;
        }

        @Nullable
        public User user() {
            return this.user;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.user == null ? that.user == null : this.user.equals(that.user);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final User.Mapper userFieldMapper = new User.Mapper();

            @Override
            public Data map(ResponseReader reader) {
                User user = reader.readObject($responseFields[0], new ResponseReader.ObjectReader<User>(){

                    @Override
                    public User read(ResponseReader reader) {
                        return userFieldMapper.map(reader);
                    }
                });
                return new Data(user);
            }
        }
    }

    public static final class Builder {
        @NotNull
        private String id;
        private Input<Integer> first = Input.absent();
        private Input<Object> after = Input.absent();

        Builder() {
        }

        public Builder id(@NotNull String id) {
            this.id = id;
            return this;
        }

        public Builder first(@Nullable Integer first) {
            this.first = Input.fromNullable(first);
            return this;
        }

        public Builder after(@Nullable Object after) {
            this.after = Input.fromNullable(after);
            return this;
        }

        public Builder firstInput(@NotNull Input<Integer> first) {
            this.first = Utils.checkNotNull(first, "first == null");
            return this;
        }

        public Builder afterInput(@NotNull Input<Object> after) {
            this.after = Utils.checkNotNull(after, "after == null");
            return this;
        }

        public FetchUserSubscriptionsQuery build() {
            Utils.checkNotNull(this.id, "id == null");
            return new FetchUserSubscriptionsQuery(this.id, this.first, this.after);
        }
    }

    public static class PageInfo {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forBoolean("hasNextPage", "hasNextPage", null, false, Collections.emptyList())};
        @NotNull
        final String __typename;
        final boolean hasNextPage;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public PageInfo(@NotNull String __typename, boolean hasNextPage) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.hasNextPage = hasNextPage;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        public boolean hasNextPage() {
            return this.hasNextPage;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeBoolean($responseFields[1], hasNextPage);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "PageInfo{__typename=" + this.__typename + ", hasNextPage=" + this.hasNextPage + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PageInfo) {
                PageInfo that = (PageInfo)o;
                return this.__typename.equals(that.__typename) && this.hasNextPage == that.hasNextPage;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= Boolean.valueOf(this.hasNextPage).hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<PageInfo> {
            @Override
            public PageInfo map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                boolean hasNextPage = reader.readBoolean($responseFields[1]);
                return new PageInfo(__typename, hasNextPage);
            }
        }
    }

    public static class User1 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("login", "login", null, false, Collections.emptyList()), ResponseField.forString("displayName", "displayName", null, false, Collections.emptyList()), ResponseField.forString("profileImageURL", "profileImageURL", new UnmodifiableMapBuilder<String, Integer>(1).put("width", 50).build(), true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        @Nullable
        final String profileImageURL;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User1(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName, @Nullable String profileImageURL) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.login = Utils.checkNotNull(login, "login == null");
            this.displayName = Utils.checkNotNull(displayName, "displayName == null");
            this.profileImageURL = profileImageURL;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @Nullable
        public String profileImageURL() {
            return this.profileImageURL;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                    writer.writeString($responseFields[4], profileImageURL);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User1{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + ", profileImageURL=" + this.profileImageURL + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User1) {
                User1 that = (User1)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName) && (this.profileImageURL == null ? that.profileImageURL == null : this.profileImageURL.equals(that.profileImageURL));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.login.hashCode();
                h2 *= 1000003;
                h2 ^= this.displayName.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.profileImageURL == null ? 0 : this.profileImageURL.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User1> {
            @Override
            public User1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                String profileImageURL = reader.readString($responseFields[4]);
                return new User1(__typename, id, login, displayName, profileImageURL);
            }
        }
    }

    public static class EmoteGroup {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, true, CustomType.ID, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final String id;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public EmoteGroup(@NotNull String __typename, @Nullable String id) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = id;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public String id() {
            return this.id;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "EmoteGroup{__typename=" + this.__typename + ", id=" + this.id + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof EmoteGroup) {
                EmoteGroup that = (EmoteGroup)o;
                return this.__typename.equals(that.__typename) && (this.id == null ? that.id == null : this.id.equals(that.id));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.id == null ? 0 : this.id.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<EmoteGroup> {
            @Override
            public EmoteGroup map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                return new EmoteGroup(__typename, id);
            }
        }
    }

    public static class Product {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forString("displayName", "displayName", null, true, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("name", "name", null, false, Collections.emptyList()), ResponseField.forList("emoteGroups", "emoteGroups", new UnmodifiableMapBuilder<String, String>(1).put("state", "ACTIVE").build(), true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final String displayName;
        @NotNull
        final String id;
        @NotNull
        final String name;
        @Nullable
        final List<EmoteGroup> emoteGroups;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Product(@NotNull String __typename, @Nullable String displayName, @NotNull String id, @NotNull String name, @Nullable List<EmoteGroup> emoteGroups) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.displayName = displayName;
            this.id = Utils.checkNotNull(id, "id == null");
            this.name = Utils.checkNotNull(name, "name == null");
            this.emoteGroups = emoteGroups;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public String displayName() {
            return this.displayName;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @Nullable
        public List<EmoteGroup> emoteGroups() {
            return this.emoteGroups;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], displayName);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], id);
                    writer.writeString($responseFields[3], name);
                    writer.writeList($responseFields[4], emoteGroups, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((EmoteGroup)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Product{__typename=" + this.__typename + ", displayName=" + this.displayName + ", id=" + this.id + ", name=" + this.name + ", emoteGroups=" + this.emoteGroups + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Product) {
                Product that = (Product)o;
                return this.__typename.equals(that.__typename) && (this.displayName == null ? that.displayName == null : this.displayName.equals(that.displayName)) && this.id.equals(that.id) && this.name.equals(that.name) && (this.emoteGroups == null ? that.emoteGroups == null : this.emoteGroups.equals(that.emoteGroups));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.displayName == null ? 0 : this.displayName.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.name.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.emoteGroups == null ? 0 : this.emoteGroups.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Product> {
            final EmoteGroup.Mapper emoteGroupFieldMapper = new EmoteGroup.Mapper();

            @Override
            public Product map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String displayName = reader.readString($responseFields[1]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                String name = reader.readString($responseFields[3]);
                List<EmoteGroup> emoteGroups = reader.readList($responseFields[4], new ResponseReader.ListReader<EmoteGroup>(){

                    @Override
                    public EmoteGroup read(ResponseReader.ListItemReader listItemReader) {
                        return listItemReader.readObject(new ResponseReader.ObjectReader<EmoteGroup>(){

                            @Override
                            public EmoteGroup read(ResponseReader reader) {
                                return emoteGroupFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new Product(__typename, displayName, id, name, emoteGroups);
            }
        }
    }

    public static class Gifter {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forString("login", "login", null, false, Collections.emptyList()), ResponseField.forString("displayName", "displayName", null, false, Collections.emptyList()), ResponseField.forString("profileImageURL", "profileImageURL", new UnmodifiableMapBuilder<String, Integer>(1).put("width", 50).build(), true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        @Nullable
        final String profileImageURL;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Gifter(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName, @Nullable String profileImageURL) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.id = Utils.checkNotNull(id, "id == null");
            this.login = Utils.checkNotNull(login, "login == null");
            this.displayName = Utils.checkNotNull(displayName, "displayName == null");
            this.profileImageURL = profileImageURL;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        @Nullable
        public String profileImageURL() {
            return this.profileImageURL;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                    writer.writeString($responseFields[4], profileImageURL);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Gifter{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + ", profileImageURL=" + this.profileImageURL + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Gifter) {
                Gifter that = (Gifter)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName) && (this.profileImageURL == null ? that.profileImageURL == null : this.profileImageURL.equals(that.profileImageURL));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.login.hashCode();
                h2 *= 1000003;
                h2 ^= this.displayName.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.profileImageURL == null ? 0 : this.profileImageURL.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Gifter> {
            @Override
            public Gifter map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                String profileImageURL = reader.readString($responseFields[4]);
                return new Gifter(__typename, id, login, displayName, profileImageURL);
            }
        }
    }

    public static class Gift {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("giftDate", "giftDate", null, true, CustomType.TIME, Collections.emptyList()), ResponseField.forObject("gifter", "gifter", null, true, Collections.emptyList()), ResponseField.forBoolean("isGift", "isGift", null, false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final Object giftDate;
        @Nullable
        final Gifter gifter;
        final boolean isGift;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Gift(@NotNull String __typename, @Nullable Object giftDate, @Nullable Gifter gifter, boolean isGift) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.giftDate = giftDate;
            this.gifter = gifter;
            this.isGift = isGift;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public Object giftDate() {
            return this.giftDate;
        }

        @Nullable
        public Gifter gifter() {
            return this.gifter;
        }

        public boolean isGift() {
            return this.isGift;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], giftDate);
                    writer.writeObject($responseFields[2], gifter != null ? gifter.marshaller() : null);
                    writer.writeBoolean($responseFields[3], isGift);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Gift{__typename=" + this.__typename + ", giftDate=" + this.giftDate + ", gifter=" + this.gifter + ", isGift=" + this.isGift + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Gift) {
                Gift that = (Gift)o;
                return this.__typename.equals(that.__typename) && (this.giftDate == null ? that.giftDate == null : this.giftDate.equals(that.giftDate)) && (this.gifter == null ? that.gifter == null : this.gifter.equals(that.gifter)) && this.isGift == that.isGift;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.giftDate == null ? 0 : this.giftDate.hashCode();
                h2 *= 1000003;
                h2 ^= this.gifter == null ? 0 : this.gifter.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= Boolean.valueOf(this.isGift).hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Gift> {
            final Gifter.Mapper gifterFieldMapper = new Gifter.Mapper();

            @Override
            public Gift map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object giftDate = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                Gifter gifter = reader.readObject($responseFields[2], new ResponseReader.ObjectReader<Gifter>(){

                    @Override
                    public Gifter read(ResponseReader reader) {
                        return gifterFieldMapper.map(reader);
                    }
                });
                boolean isGift = reader.readBoolean($responseFields[3]);
                return new Gift(__typename, giftDate, gifter, isGift);
            }
        }
    }

    public static class Node {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("endsAt", "endsAt", null, true, CustomType.TIME, Collections.emptyList()), ResponseField.forObject("gift", "gift", null, true, Collections.emptyList()), ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.emptyList()), ResponseField.forObject("product", "product", null, true, Collections.emptyList()), ResponseField.forBoolean("purchasedWithPrime", "purchasedWithPrime", null, false, Collections.emptyList()), ResponseField.forCustomType("renewsAt", "renewsAt", null, true, CustomType.TIME, Collections.emptyList()), ResponseField.forString("tier", "tier", null, false, Collections.emptyList()), ResponseField.forObject("user", "user", null, true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final Object endsAt;
        @Nullable
        final Gift gift;
        @NotNull
        final String id;
        @Nullable
        final Product product;
        final boolean purchasedWithPrime;
        @Nullable
        final Object renewsAt;
        @NotNull
        final String tier;
        @Nullable
        final User1 user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Node(@NotNull String __typename, @Nullable Object endsAt, @Nullable Gift gift, @NotNull String id, @Nullable Product product, boolean purchasedWithPrime, @Nullable Object renewsAt, @NotNull String tier, @Nullable User1 user) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.endsAt = endsAt;
            this.gift = gift;
            this.id = Utils.checkNotNull(id, "id == null");
            this.product = product;
            this.purchasedWithPrime = purchasedWithPrime;
            this.renewsAt = renewsAt;
            this.tier = Utils.checkNotNull(tier, "tier == null");
            this.user = user;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public Object endsAt() {
            return this.endsAt;
        }

        @Nullable
        public Gift gift() {
            return this.gift;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public Product product() {
            return this.product;
        }

        public boolean purchasedWithPrime() {
            return this.purchasedWithPrime;
        }

        @Nullable
        public Object renewsAt() {
            return this.renewsAt;
        }

        @NotNull
        public String tier() {
            return this.tier;
        }

        @Nullable
        public User1 user() {
            return this.user;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], endsAt);
                    writer.writeObject($responseFields[2], gift != null ? gift.marshaller() : null);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[3], id);
                    writer.writeObject($responseFields[4], product != null ? product.marshaller() : null);
                    writer.writeBoolean($responseFields[5], purchasedWithPrime);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[6], renewsAt);
                    writer.writeString($responseFields[7], tier);
                    writer.writeObject($responseFields[8], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Node{__typename=" + this.__typename + ", endsAt=" + this.endsAt + ", gift=" + this.gift + ", id=" + this.id + ", product=" + this.product + ", purchasedWithPrime=" + this.purchasedWithPrime + ", renewsAt=" + this.renewsAt + ", tier=" + this.tier + ", user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Node) {
                Node that = (Node)o;
                return this.__typename.equals(that.__typename) && (this.endsAt == null ? that.endsAt == null : this.endsAt.equals(that.endsAt)) && (this.gift == null ? that.gift == null : this.gift.equals(that.gift)) && this.id.equals(that.id) && (this.product == null ? that.product == null : this.product.equals(that.product)) && this.purchasedWithPrime == that.purchasedWithPrime && (this.renewsAt == null ? that.renewsAt == null : this.renewsAt.equals(that.renewsAt)) && this.tier.equals(that.tier) && (this.user == null ? that.user == null : this.user.equals(that.user));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.endsAt == null ? 0 : this.endsAt.hashCode();
                h2 *= 1000003;
                h2 ^= this.gift == null ? 0 : this.gift.hashCode();
                h2 *= 1000003;
                h2 ^= this.id.hashCode();
                h2 *= 1000003;
                h2 ^= this.product == null ? 0 : this.product.hashCode();
                h2 *= 1000003;
                h2 ^= Boolean.valueOf(this.purchasedWithPrime).hashCode();
                h2 *= 1000003;
                h2 ^= this.renewsAt == null ? 0 : this.renewsAt.hashCode();
                h2 *= 1000003;
                h2 ^= this.tier.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Node> {
            final Gift.Mapper giftFieldMapper = new Gift.Mapper();
            final Product.Mapper productFieldMapper = new Product.Mapper();
            final User1.Mapper user1FieldMapper = new User1.Mapper();

            @Override
            public Node map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object endsAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                Gift gift = reader.readObject($responseFields[2], new ResponseReader.ObjectReader<Gift>(){

                    @Override
                    public Gift read(ResponseReader reader) {
                        return giftFieldMapper.map(reader);
                    }
                });
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[3]);
                Product product = reader.readObject($responseFields[4], new ResponseReader.ObjectReader<Product>(){

                    @Override
                    public Product read(ResponseReader reader) {
                        return productFieldMapper.map(reader);
                    }
                });
                boolean purchasedWithPrime = reader.readBoolean($responseFields[5]);
                Object renewsAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[6]);
                String tier = reader.readString($responseFields[7]);
                User1 user = reader.readObject($responseFields[8], new ResponseReader.ObjectReader<User1>(){

                    @Override
                    public User1 read(ResponseReader reader) {
                        return user1FieldMapper.map(reader);
                    }
                });
                return new Node(__typename, endsAt, gift, id, product, purchasedWithPrime, renewsAt, tier, user);
            }
        }
    }

    public static class Edge {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forCustomType("cursor", "cursor", null, false, CustomType.CURSOR, Collections.emptyList()), ResponseField.forObject("node", "node", null, true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Object cursor;
        @Nullable
        final Node node;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Edge(@NotNull String __typename, @NotNull Object cursor, @Nullable Node node) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.cursor = Utils.checkNotNull(cursor, "cursor == null");
            this.node = node;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public Object cursor() {
            return this.cursor;
        }

        @Nullable
        public Node node() {
            return this.node;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], cursor);
                    writer.writeObject($responseFields[2], node != null ? node.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Edge{__typename=" + this.__typename + ", cursor=" + this.cursor + ", node=" + this.node + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Edge) {
                Edge that = (Edge)o;
                return this.__typename.equals(that.__typename) && this.cursor.equals(that.cursor) && (this.node == null ? that.node == null : this.node.equals(that.node));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.cursor.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.node == null ? 0 : this.node.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Edge> {
            final Node.Mapper nodeFieldMapper = new Node.Mapper();

            @Override
            public Edge map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object cursor = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                Node node = reader.readObject($responseFields[2], new ResponseReader.ObjectReader<Node>(){

                    @Override
                    public Node read(ResponseReader reader) {
                        return nodeFieldMapper.map(reader);
                    }
                });
                return new Edge(__typename, cursor, node);
            }
        }
    }

    public static class SubscriptionBenefits {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forList("edges", "edges", null, true, Collections.emptyList()), ResponseField.forObject("pageInfo", "pageInfo", null, false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final List<Edge> edges;
        @NotNull
        final PageInfo pageInfo;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public SubscriptionBenefits(@NotNull String __typename, @Nullable List<Edge> edges, @NotNull PageInfo pageInfo) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.edges = edges;
            this.pageInfo = Utils.checkNotNull(pageInfo, "pageInfo == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public List<Edge> edges() {
            return this.edges;
        }

        @NotNull
        public PageInfo pageInfo() {
            return this.pageInfo;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], edges, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Edge)item).marshaller());
                            }
                        }
                    });
                    writer.writeObject($responseFields[2], pageInfo.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "SubscriptionBenefits{__typename=" + this.__typename + ", edges=" + this.edges + ", pageInfo=" + this.pageInfo + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SubscriptionBenefits) {
                SubscriptionBenefits that = (SubscriptionBenefits)o;
                return this.__typename.equals(that.__typename) && (this.edges == null ? that.edges == null : this.edges.equals(that.edges)) && this.pageInfo.equals(that.pageInfo);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                h2 ^= this.edges == null ? 0 : this.edges.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.pageInfo.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<SubscriptionBenefits> {
            final Edge.Mapper edgeFieldMapper = new Edge.Mapper();
            final PageInfo.Mapper pageInfoFieldMapper = new PageInfo.Mapper();

            @Override
            public SubscriptionBenefits map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List<Edge> edges = reader.readList($responseFields[1], new ResponseReader.ListReader<Edge>(){

                    @Override
                    public Edge read(ResponseReader.ListItemReader listItemReader) {
                        return listItemReader.readObject(new ResponseReader.ObjectReader<Edge>(){

                            @Override
                            public Edge read(ResponseReader reader) {
                                return edgeFieldMapper.map(reader);
                            }
                        });
                    }
                });
                PageInfo pageInfo = reader.readObject($responseFields[2], new ResponseReader.ObjectReader<PageInfo>(){

                    @Override
                    public PageInfo read(ResponseReader reader) {
                        return pageInfoFieldMapper.map(reader);
                    }
                });
                return new SubscriptionBenefits(__typename, edges, pageInfo);
            }
        }
    }

    public static class User {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString("__typename", "__typename", null, false, Collections.emptyList()), ResponseField.forObject("subscriptionBenefits", "subscriptionBenefits", new UnmodifiableMapBuilder<String, Map<String, String>>(3).put("first", new UnmodifiableMapBuilder<String, String>(2).put("kind", "Variable").put("variableName", "first").build()).put("after", new UnmodifiableMapBuilder<String, String>(2).put("kind", "Variable").put("variableName", "after").build()).put("criteria", new UnmodifiableMapBuilder<String, String>(1).put("filter", "ALL").build()).build(), true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final SubscriptionBenefits subscriptionBenefits;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User(@NotNull String __typename, @Nullable SubscriptionBenefits subscriptionBenefits) {
            this.__typename = Utils.checkNotNull(__typename, "__typename == null");
            this.subscriptionBenefits = subscriptionBenefits;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public SubscriptionBenefits subscriptionBenefits() {
            return this.subscriptionBenefits;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                @Override
                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], subscriptionBenefits != null ? subscriptionBenefits.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User{__typename=" + this.__typename + ", subscriptionBenefits=" + this.subscriptionBenefits + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User) {
                User that = (User)o;
                return this.__typename.equals(that.__typename) && (this.subscriptionBenefits == null ? that.subscriptionBenefits == null : this.subscriptionBenefits.equals(that.subscriptionBenefits));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h2 = 1;
                h2 *= 1000003;
                h2 ^= this.__typename.hashCode();
                h2 *= 1000003;
                this.$hashCode = h2 ^= this.subscriptionBenefits == null ? 0 : this.subscriptionBenefits.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User> {
            final SubscriptionBenefits.Mapper subscriptionBenefitsFieldMapper = new SubscriptionBenefits.Mapper();

            @Override
            public User map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                SubscriptionBenefits subscriptionBenefits = reader.readObject($responseFields[1], new ResponseReader.ObjectReader<SubscriptionBenefits>(){

                    @Override
                    public SubscriptionBenefits read(ResponseReader reader) {
                        return subscriptionBenefitsFieldMapper.map(reader);
                    }
                });
                return new User(__typename, subscriptionBenefits);
            }
        }
    }
}

