/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.helix;

import com.morelaid.streamingmodule.external.jackson.databind.ObjectMapper;
import com.morelaid.streamingmodule.external.twitch4j.common.exception.NotFoundException;
import com.morelaid.streamingmodule.external.twitch4j.common.exception.UnauthorizedException;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.TwitchHelixError;
import com.morelaid.streamingmodule.external.twitch4j.helix.interceptor.TwitchHelixRateLimitTracker;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.RetryableException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixErrorDecoder
implements ErrorDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixErrorDecoder.class);
    final Decoder decoder;
    final TwitchHelixRateLimitTracker rateLimitTracker;
    final ErrorDecoder defaultDecoder = new ErrorDecoder.Default();
    final ObjectMapper objectMapper = TypeConvert.getObjectMapper();

    public TwitchHelixErrorDecoder(Decoder decoder, TwitchHelixRateLimitTracker rateLimitTracker) {
        this.decoder = decoder;
        this.rateLimitTracker = rateLimitTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exception decode(String methodKey, Response response) {
        Exception ex;
        try (InputStream is = response.body() == null ? null : response.body().asInputStream();){
            String responseBody;
            String string = responseBody = is == null ? "" : IOUtils.toString(is, StandardCharsets.UTF_8);
            if (response.status() == 401) {
                ex = new UnauthorizedException().addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody).addContextValue("errorStatus", response.status());
            } else if (response.status() == 404) {
                ex = new NotFoundException().addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody).addContextValue("errorStatus", response.status());
            } else if (response.status() == 429) {
                ex = new ContextedRuntimeException("Too many requests!").addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody).addContextValue("errorStatus", response.status());
                RequestTemplate template = response.request().requestTemplate();
                if (template.path().endsWith("/moderation/bans")) {
                    String channelId = template.queries().get("broadcaster_id").iterator().next();
                    this.rateLimitTracker.markDepletedBanBucket(channelId);
                }
            } else if (response.status() == 503) {
                ex = new RetryableException(response.status(), "getting service unavailable, retrying ...", Request.HttpMethod.GET, (Long)null, response.request());
            } else {
                TwitchHelixError error = this.objectMapper.readValue(responseBody, TwitchHelixError.class);
                ex = new ContextedRuntimeException("Helix API Error").addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody).addContextValue("errorType", error.getError()).addContextValue("errorStatus", error.getStatus()).addContextValue("errorType", error.getMessage()).addContextValue("errorMessage", error.getMessage());
            }
        }
        catch (Exception fallbackToDefault) {
            ex = this.defaultDecoder.decode(methodKey, response);
        }
        finally {
            response.close();
        }
        return ex;
    }
}

