/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.helix.domain;

import com.morelaid.streamingmodule.external.jackson.annotation.JsonInclude;
import com.morelaid.streamingmodule.external.jackson.annotation.JsonProperty;
import com.morelaid.streamingmodule.external.jackson.annotation.JsonPropertyOrder;
import com.morelaid.streamingmodule.external.jackson.databind.annotation.JsonDeserialize;
import com.morelaid.streamingmodule.external.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(alphabetic=true)
@JsonDeserialize(builder=SendPubSubMessageInputBuilder.class)
public class SendPubSubMessageInput {
    public static final String BROADCAST_TARGET = "broadcast";
    public static final String GLOBAL_TARGET = "global";
    public static final String WHISPER_TARGET_PREFIX = "whisper-";
    @JsonProperty(value="target")
    private List<String> targets;
    @Nullable
    private String broadcasterId;
    @JsonProperty(value="is_global_broadcast")
    private boolean globalBroadcast;
    private String message;

    public boolean validate() {
        if (this.message == null) {
            return false;
        }
        if (this.globalBroadcast == (this.broadcasterId != null && !this.broadcasterId.isEmpty())) {
            return false;
        }
        if (this.targets == null || this.targets.isEmpty()) {
            return false;
        }
        boolean hasGlobal = false;
        for (String target : this.targets) {
            if (target == null || target.isEmpty()) {
                return false;
            }
            if (BROADCAST_TARGET.equals(target) || target.startsWith(WHISPER_TARGET_PREFIX)) continue;
            if (GLOBAL_TARGET.equals(target)) {
                hasGlobal = true;
                continue;
            }
            return false;
        }
        return this.globalBroadcast != !hasGlobal;
    }

    @Generated
    private static boolean $default$globalBroadcast() {
        return false;
    }

    @Generated
    public static SendPubSubMessageInputBuilder builder() {
        return new SendPubSubMessageInputBuilder();
    }

    @Generated
    public SendPubSubMessageInputBuilder toBuilder() {
        SendPubSubMessageInputBuilder builder = new SendPubSubMessageInputBuilder().broadcasterId(this.broadcasterId).globalBroadcast(this.globalBroadcast).message(this.message);
        if (this.targets != null) {
            builder.targets(this.targets);
        }
        return builder;
    }

    @Generated
    public SendPubSubMessageInput withTargets(List<String> targets) {
        return this.targets == targets ? this : new SendPubSubMessageInput(targets, this.broadcasterId, this.globalBroadcast, this.message);
    }

    @Generated
    public SendPubSubMessageInput withBroadcasterId(@Nullable String broadcasterId) {
        return this.broadcasterId == broadcasterId ? this : new SendPubSubMessageInput(this.targets, broadcasterId, this.globalBroadcast, this.message);
    }

    @Generated
    public SendPubSubMessageInput withGlobalBroadcast(boolean globalBroadcast) {
        return this.globalBroadcast == globalBroadcast ? this : new SendPubSubMessageInput(this.targets, this.broadcasterId, globalBroadcast, this.message);
    }

    @Generated
    public SendPubSubMessageInput withMessage(String message) {
        return this.message == message ? this : new SendPubSubMessageInput(this.targets, this.broadcasterId, this.globalBroadcast, message);
    }

    @Generated
    public List<String> getTargets() {
        return this.targets;
    }

    @Nullable
    @Generated
    public String getBroadcasterId() {
        return this.broadcasterId;
    }

    @Generated
    public boolean isGlobalBroadcast() {
        return this.globalBroadcast;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendPubSubMessageInput)) {
            return false;
        }
        SendPubSubMessageInput other = (SendPubSubMessageInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGlobalBroadcast() != other.isGlobalBroadcast()) {
            return false;
        }
        List<String> this$targets = this.getTargets();
        List<String> other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        String this$broadcasterId = this.getBroadcasterId();
        String other$broadcasterId = other.getBroadcasterId();
        if (this$broadcasterId == null ? other$broadcasterId != null : !this$broadcasterId.equals(other$broadcasterId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendPubSubMessageInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGlobalBroadcast() ? 79 : 97);
        List<String> $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        String $broadcasterId = this.getBroadcasterId();
        result = result * 59 + ($broadcasterId == null ? 43 : $broadcasterId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SendPubSubMessageInput(targets=" + this.getTargets() + ", broadcasterId=" + this.getBroadcasterId() + ", globalBroadcast=" + this.isGlobalBroadcast() + ", message=" + this.getMessage() + ")";
    }

    @JsonProperty(value="target")
    @Generated
    private void setTargets(List<String> targets) {
        this.targets = targets;
    }

    @Generated
    private void setBroadcasterId(@Nullable String broadcasterId) {
        this.broadcasterId = broadcasterId;
    }

    @JsonProperty(value="is_global_broadcast")
    @Generated
    private void setGlobalBroadcast(boolean globalBroadcast) {
        this.globalBroadcast = globalBroadcast;
    }

    @Generated
    private void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public SendPubSubMessageInput() {
        this.globalBroadcast = SendPubSubMessageInput.$default$globalBroadcast();
    }

    @Generated
    public SendPubSubMessageInput(List<String> targets, @Nullable String broadcasterId, boolean globalBroadcast, String message) {
        this.targets = targets;
        this.broadcasterId = broadcasterId;
        this.globalBroadcast = globalBroadcast;
        this.message = message;
    }

    @JsonPropertyOrder(alphabetic=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class SendPubSubMessageInputBuilder {
        @Generated
        private ArrayList<String> targets;
        @Generated
        private String broadcasterId;
        @Generated
        private boolean globalBroadcast$set;
        @Generated
        private boolean globalBroadcast$value;
        @Generated
        private String message;

        @Generated
        SendPubSubMessageInputBuilder() {
        }

        @Generated
        public SendPubSubMessageInputBuilder target(String target) {
            if (this.targets == null) {
                this.targets = new ArrayList();
            }
            this.targets.add(target);
            return this;
        }

        @JsonProperty(value="target")
        @Generated
        public SendPubSubMessageInputBuilder targets(Collection<? extends String> targets) {
            if (targets == null) {
                throw new NullPointerException("targets cannot be null");
            }
            if (this.targets == null) {
                this.targets = new ArrayList();
            }
            this.targets.addAll(targets);
            return this;
        }

        @Generated
        public SendPubSubMessageInputBuilder clearTargets() {
            if (this.targets != null) {
                this.targets.clear();
            }
            return this;
        }

        @Generated
        public SendPubSubMessageInputBuilder broadcasterId(@Nullable String broadcasterId) {
            this.broadcasterId = broadcasterId;
            return this;
        }

        @JsonProperty(value="is_global_broadcast")
        @Generated
        public SendPubSubMessageInputBuilder globalBroadcast(boolean globalBroadcast) {
            this.globalBroadcast$value = globalBroadcast;
            this.globalBroadcast$set = true;
            return this;
        }

        @Generated
        public SendPubSubMessageInputBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public SendPubSubMessageInput build() {
            List<String> targets;
            switch (this.targets == null ? 0 : this.targets.size()) {
                case 0: {
                    targets = Collections.emptyList();
                    break;
                }
                case 1: {
                    targets = Collections.singletonList(this.targets.get(0));
                    break;
                }
                default: {
                    targets = Collections.unmodifiableList(new ArrayList<String>(this.targets));
                }
            }
            boolean globalBroadcast$value = this.globalBroadcast$value;
            if (!this.globalBroadcast$set) {
                globalBroadcast$value = SendPubSubMessageInput.$default$globalBroadcast();
            }
            return new SendPubSubMessageInput(targets, this.broadcasterId, globalBroadcast$value, this.message);
        }

        @Generated
        public String toString() {
            return "SendPubSubMessageInput.SendPubSubMessageInputBuilder(targets=" + this.targets + ", broadcasterId=" + this.broadcasterId + ", globalBroadcast$value=" + this.globalBroadcast$value + ", message=" + this.message + ")";
        }
    }
}

