/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.helix.interceptor;

import com.github.philippheuer.credentialmanager.domain.Credential;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.morelaid.streamingmodule.external.twitch4j.common.enums.TwitchLimitType;
import com.morelaid.streamingmodule.external.twitch4j.common.util.BucketUtils;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TwitchLimitRegistry;
import com.morelaid.streamingmodule.external.twitch4j.helix.interceptor.TwitchHelixTokenManager;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthBuilder;
import io.github.bucket4j.Bucket;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.core.CacheApi;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class TwitchHelixRateLimitTracker {
    private static final Bandwidth ANNOUNCE_BANDWIDTH = BucketUtils.simple(1L, Duration.ofSeconds(2L));
    private static final String AUTOMOD_STATUS_MINUTE_ID = (Object)((Object)TwitchLimitType.HELIX_AUTOMOD_STATUS_LIMIT) + "-min";
    private static final String AUTOMOD_STATUS_HOUR_ID = (Object)((Object)TwitchLimitType.HELIX_AUTOMOD_STATUS_LIMIT) + "-hr";
    private static final String WHISPER_MINUTE_BANDWIDTH_ID = TwitchLimitType.CHAT_WHISPER_LIMIT.getBandwidthId() + "-minute";
    private static final String WHISPER_SECOND_BANDWIDTH_ID = TwitchLimitType.CHAT_WHISPER_LIMIT.getBandwidthId() + "-second";
    public static final List<Bandwidth> AUTOMOD_STATUS_NORMAL_BANDWIDTH = Arrays.asList(BucketUtils.simple(5L, Duration.ofMinutes(1L), AUTOMOD_STATUS_MINUTE_ID), BucketUtils.simple(50L, Duration.ofHours(1L), AUTOMOD_STATUS_HOUR_ID));
    public static final List<Bandwidth> AUTOMOD_STATUS_AFFILIATE_BANDWIDTH = Arrays.asList(BucketUtils.simple(10L, Duration.ofMinutes(1L), AUTOMOD_STATUS_MINUTE_ID), BucketUtils.simple(100L, Duration.ofHours(1L), AUTOMOD_STATUS_HOUR_ID));
    public static final List<Bandwidth> AUTOMOD_STATUS_PARTNER_BANDWIDTH = Arrays.asList(BucketUtils.simple(30L, Duration.ofMinutes(1L), AUTOMOD_STATUS_MINUTE_ID), BucketUtils.simple(300L, Duration.ofHours(1L), AUTOMOD_STATUS_HOUR_ID));
    private static final Bandwidth MOD_BANDWIDTH = BucketUtils.simple(10L, Duration.ofSeconds(10L));
    private static final Bandwidth RAIDS_BANDWIDTH = BucketUtils.simple(10L, Duration.ofMinutes(10L));
    private static final Bandwidth EXT_CHAT_BANDWIDTH = BucketUtils.simple(12L, Duration.ofMinutes(1L));
    private static final Bandwidth EXT_PUBSUB_BANDWIDTH = BandwidthBuilder.builder().capacity(100L).refillGreedy(1L, Duration.ofSeconds(1L)).build();
    private static final Bandwidth VIP_BANDWIDTH = BucketUtils.simple(10L, Duration.ofSeconds(10L));
    private static final List<Bandwidth> WHISPERS_BANDWIDTH = Arrays.asList(BucketUtils.simple(100L, Duration.ofSeconds(60L), WHISPER_MINUTE_BANDWIDTH_ID), BucketUtils.simple(3L, Duration.ofSeconds(1L), WHISPER_SECOND_BANDWIDTH_ID));
    private static final Bandwidth BANS_BANDWIDTH = BucketUtils.simple(100L, Duration.ofSeconds(30L));
    private static final Bandwidth CLIPS_BANDWIDTH = BucketUtils.simple(600L, Duration.ofSeconds(60L));
    private static final Bandwidth TERMS_BANDWIDTH = BucketUtils.simple(60L, Duration.ofSeconds(60L));
    private final Cache<String, Bucket> primaryBuckets = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofMinutes(1L));
    });
    private final Cache<String, Bucket> extensionChatBuckets = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofMinutes(1L));
    });
    private final Cache<String, Bucket> extensionPubSubBuckets = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofSeconds(100L));
    });
    private final Cache<String, Bucket> addModByChannelId = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofSeconds(30L));
    });
    private final Cache<String, Bucket> removeModByChannelId = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofSeconds(30L));
    });
    private final Cache<String, Bucket> raidsByChannelId = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofMinutes(10L));
    });
    private final Cache<String, Bucket> addVipByChannelId = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofSeconds(30L));
    });
    private final Cache<String, Bucket> removeVipByChannelId = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofSeconds(30L));
    });
    private final Cache<String, Bucket> bansByChannelId = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofMinutes(1L));
    });
    private final Cache<String, Bucket> clipsByUserId = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofMinutes(1L));
    });
    private final Cache<String, Bucket> termsByChannelId = CacheApi.create(spec -> {
        spec.maxSize(1024L);
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofMinutes(1L));
    });
    private final Bandwidth apiRateLimit;
    private final TwitchHelixTokenManager tokenManager;

    @NotNull
    Bucket getOrInitializeBucket(@NotNull String key) {
        return this.primaryBuckets.computeIfAbsent(key, k -> BucketUtils.createBucket(this.apiRateLimit));
    }

    @NotNull
    String getPrimaryBucketKey(@NotNull OAuth2Credential credential) {
        String clientId = TwitchHelixTokenManager.extractClientId(credential);
        return clientId == null ? "" : (StringUtils.isEmpty(credential.getUserId()) ? clientId : clientId + "-" + credential.getUserId());
    }

    @NotNull
    Bucket getExtensionChatBucket(@NotNull String clientId, @NotNull String channelId) {
        return this.extensionChatBuckets.computeIfAbsent(clientId + ':' + channelId, k -> BucketUtils.createBucket(EXT_CHAT_BANDWIDTH));
    }

    @NotNull
    Bucket getExtensionPubSubBucket(@NotNull String clientId, @NotNull String channelId) {
        return this.extensionPubSubBuckets.computeIfAbsent(clientId + ':' + channelId, k -> BucketUtils.createBucket(EXT_PUBSUB_BANDWIDTH));
    }

    @NotNull
    Bucket getChatAnnouncementBucket(@NotNull String channelId) {
        return TwitchLimitRegistry.getInstance().getOrInitializeBucket(channelId, TwitchLimitType.HELIX_ANNOUNCEMENT_LIMIT, Collections.singletonList(ANNOUNCE_BANDWIDTH));
    }

    @NotNull
    Bucket getAutomodStatusBucket(@NotNull String channelId) {
        return TwitchLimitRegistry.getInstance().getOrInitializeBucket(channelId, TwitchLimitType.HELIX_AUTOMOD_STATUS_LIMIT, AUTOMOD_STATUS_NORMAL_BANDWIDTH);
    }

    @NotNull
    Bucket getModAddBucket(@NotNull String channelId) {
        return this.addModByChannelId.computeIfAbsent(channelId, k -> BucketUtils.createBucket(MOD_BANDWIDTH));
    }

    @NotNull
    Bucket getModRemoveBucket(@NotNull String channelId) {
        return this.removeModByChannelId.computeIfAbsent(channelId, k -> BucketUtils.createBucket(MOD_BANDWIDTH));
    }

    @NotNull
    Bucket getRaidsBucket(@NotNull String channelId) {
        return this.raidsByChannelId.computeIfAbsent(channelId, k -> BucketUtils.createBucket(RAIDS_BANDWIDTH));
    }

    @NotNull
    Bucket getVipAddBucket(@NotNull String channelId) {
        return this.addVipByChannelId.computeIfAbsent(channelId, k -> BucketUtils.createBucket(VIP_BANDWIDTH));
    }

    @NotNull
    Bucket getVipRemoveBucket(@NotNull String channelId) {
        return this.removeVipByChannelId.computeIfAbsent(channelId, k -> BucketUtils.createBucket(VIP_BANDWIDTH));
    }

    @NotNull
    Bucket getWhispersBucket(@NotNull String userId) {
        return TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_WHISPER_LIMIT, WHISPERS_BANDWIDTH);
    }

    @NotNull
    Bucket getModerationBucket(@NotNull String channelId) {
        return this.bansByChannelId.computeIfAbsent(channelId, k -> BucketUtils.createBucket(BANS_BANDWIDTH));
    }

    @NotNull
    Bucket getClipBucket(@NotNull String userId) {
        return this.clipsByUserId.computeIfAbsent(userId, k -> BucketUtils.createBucket(CLIPS_BANDWIDTH));
    }

    @NotNull
    Bucket getTermsBucket(@NotNull String channelId) {
        return this.termsByChannelId.computeIfAbsent(channelId, k -> BucketUtils.createBucket(TERMS_BANDWIDTH));
    }

    public void updateRemaining(@NotNull String token, int remaining) {
        this.updateRemainingGeneric(token, remaining, this::getPrimaryBucketKey, this::getOrInitializeBucket);
    }

    public void updateRemainingExtensionChat(@NotNull String clientId, @NotNull String channelId, int remaining) {
        this.updateRemainingConservative(this.getExtensionChatBucket(clientId, channelId), remaining);
    }

    public void updateRemainingExtensionPubSub(@NotNull String clientId, @NotNull String target, int remaining) {
        this.updateRemainingConservative(this.getExtensionPubSubBucket(clientId, target), remaining);
    }

    public void updateRemainingCreateClip(@NotNull String token, int remaining) {
        this.updateRemainingGeneric(token, remaining, Credential::getUserId, this::getClipBucket);
    }

    public void markDepletedBanBucket(@NotNull String channelId) {
        Bucket modBucket = this.getModerationBucket(channelId);
        modBucket.consumeIgnoringRateLimits(Math.max(modBucket.tryConsumeAsMuchAsPossible(), 1L));
    }

    private void updateRemainingGeneric(String token, int remaining, Function<OAuth2Credential, String> credToKey, Function<String, Bucket> keyToBucket) {
        OAuth2Credential credential = this.tokenManager.getIfPresent(token);
        if (credential == null) {
            return;
        }
        String key = credToKey.apply(credential);
        if (key == null) {
            return;
        }
        Bucket bucket = keyToBucket.apply(key);
        this.updateRemainingConservative(bucket, remaining);
    }

    private void updateRemainingConservative(Bucket bucket, int remaining) {
        long diff = bucket.getAvailableTokens() - (long)remaining;
        if (diff > 0L) {
            bucket.tryConsumeAsMuchAsPossible(diff);
        }
    }

    @Generated
    public TwitchHelixRateLimitTracker(Bandwidth apiRateLimit, TwitchHelixTokenManager tokenManager) {
        this.apiRateLimit = apiRateLimit;
        this.tokenManager = tokenManager;
    }
}

