/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.domain;

import com.morelaid.streamingmodule.external.jackson.annotation.JsonCreator;
import com.morelaid.streamingmodule.external.twitch4j.util.EnumUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public class ChatModerationAction {
    private String type;
    private ModerationAction moderationAction;
    private List<String> args;
    private String createdBy;
    private String createdByUserId;
    private String msgId;
    private String targetUserId;
    private String targetUserLogin;
    private Boolean fromAutomod;
    private final AtomicReference<Object> modType = new AtomicReference();

    public Optional<String> getTargetedUserName() {
        ModerationAction action = this.getModerationAction();
        if (this.args != null && this.args.size() > 0 && (action == ModerationAction.BAN || action == ModerationAction.UNBAN || action == ModerationAction.TIMEOUT || action == ModerationAction.UNTIMEOUT || action == ModerationAction.DELETE || action == ModerationAction.HOST || action == ModerationAction.VIP || action == ModerationAction.UNVIP || action == ModerationAction.MOD || action == ModerationAction.UNMOD || action == ModerationAction.RAID)) {
            return Optional.of(this.args.get(0));
        }
        return Optional.ofNullable(this.targetUserLogin).filter(s2 -> !s2.isEmpty());
    }

    public Optional<String> getReason() {
        switch (this.getModerationAction()) {
            case BAN: {
                if (this.args != null && this.args.size() > 1) {
                    return Optional.of(this.args.get(1));
                }
            }
            case TIMEOUT: {
                if (this.args != null && this.args.size() > 2) {
                    return Optional.of(this.args.get(2));
                }
            }
            case WARN: {
                if (this.args == null || this.args.size() <= 1) break;
                List<String> reasons = this.args.subList(1, this.args.size());
                return Optional.of(String.join((CharSequence)"\n", reasons).trim());
            }
        }
        return Optional.empty();
    }

    public Optional<String> getDeletedMessage() {
        if (this.getModerationAction() == ModerationAction.DELETE && this.args != null && this.args.size() > 1) {
            return Optional.of(this.args.get(1));
        }
        return Optional.empty();
    }

    public OptionalInt getTimeoutDuration() {
        if (this.getModerationAction() == ModerationAction.TIMEOUT && this.args != null && this.args.size() > 1) {
            return OptionalInt.of(Integer.parseInt(this.args.get(1)));
        }
        return OptionalInt.empty();
    }

    public OptionalInt getSlowDuration() {
        if (this.getModerationAction() == ModerationAction.SLOW && this.args != null && this.args.size() > 0) {
            return OptionalInt.of(Integer.parseInt(this.args.get(0)));
        }
        return OptionalInt.empty();
    }

    public OptionalInt getFollowersDuration() {
        if (this.getModerationAction() == ModerationAction.FOLLOWERS && this.args != null && this.args.size() > 0) {
            return OptionalInt.of(Integer.parseInt(this.args.get(0)));
        }
        return OptionalInt.empty();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public ModerationAction getModerationAction() {
        return this.moderationAction;
    }

    @Generated
    public List<String> getArgs() {
        return this.args;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    @Generated
    public String getMsgId() {
        return this.msgId;
    }

    @Generated
    public String getTargetUserId() {
        return this.targetUserId;
    }

    @Generated
    public String getTargetUserLogin() {
        return this.targetUserLogin;
    }

    @Generated
    public Boolean getFromAutomod() {
        return this.fromAutomod;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatModerationAction)) {
            return false;
        }
        ChatModerationAction other = (ChatModerationAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$fromAutomod = this.getFromAutomod();
        Boolean other$fromAutomod = other.getFromAutomod();
        if (this$fromAutomod == null ? other$fromAutomod != null : !((Object)this$fromAutomod).equals(other$fromAutomod)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ModerationAction this$moderationAction = this.getModerationAction();
        ModerationAction other$moderationAction = other.getModerationAction();
        if (this$moderationAction == null ? other$moderationAction != null : !((Object)((Object)this$moderationAction)).equals((Object)other$moderationAction)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$createdByUserId = this.getCreatedByUserId();
        String other$createdByUserId = other.getCreatedByUserId();
        if (this$createdByUserId == null ? other$createdByUserId != null : !this$createdByUserId.equals(other$createdByUserId)) {
            return false;
        }
        String this$msgId = this.getMsgId();
        String other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
            return false;
        }
        String this$targetUserId = this.getTargetUserId();
        String other$targetUserId = other.getTargetUserId();
        if (this$targetUserId == null ? other$targetUserId != null : !this$targetUserId.equals(other$targetUserId)) {
            return false;
        }
        String this$targetUserLogin = this.getTargetUserLogin();
        String other$targetUserLogin = other.getTargetUserLogin();
        if (this$targetUserLogin == null ? other$targetUserLogin != null : !this$targetUserLogin.equals(other$targetUserLogin)) {
            return false;
        }
        ModerationType this$modType = this.getModType();
        ModerationType other$modType = other.getModType();
        return !(this$modType == null ? other$modType != null : !((Object)((Object)this$modType)).equals((Object)other$modType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatModerationAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $fromAutomod = this.getFromAutomod();
        result = result * 59 + ($fromAutomod == null ? 43 : ((Object)$fromAutomod).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ModerationAction $moderationAction = this.getModerationAction();
        result = result * 59 + ($moderationAction == null ? 43 : ((Object)((Object)$moderationAction)).hashCode());
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $createdByUserId = this.getCreatedByUserId();
        result = result * 59 + ($createdByUserId == null ? 43 : $createdByUserId.hashCode());
        String $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        String $targetUserId = this.getTargetUserId();
        result = result * 59 + ($targetUserId == null ? 43 : $targetUserId.hashCode());
        String $targetUserLogin = this.getTargetUserLogin();
        result = result * 59 + ($targetUserLogin == null ? 43 : $targetUserLogin.hashCode());
        ModerationType $modType = this.getModType();
        result = result * 59 + ($modType == null ? 43 : ((Object)((Object)$modType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChatModerationAction(type=" + this.getType() + ", moderationAction=" + (Object)((Object)this.getModerationAction()) + ", args=" + this.getArgs() + ", createdBy=" + this.getCreatedBy() + ", createdByUserId=" + this.getCreatedByUserId() + ", msgId=" + this.getMsgId() + ", targetUserId=" + this.getTargetUserId() + ", targetUserLogin=" + this.getTargetUserLogin() + ", fromAutomod=" + this.getFromAutomod() + ", modType=" + (Object)((Object)this.getModType()) + ")";
    }

    @Deprecated
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Deprecated
    @Generated
    public void setModerationAction(ModerationAction moderationAction) {
        this.moderationAction = moderationAction;
    }

    @Deprecated
    @Generated
    public void setArgs(List<String> args2) {
        this.args = args2;
    }

    @Deprecated
    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Deprecated
    @Generated
    public void setCreatedByUserId(String createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    @Deprecated
    @Generated
    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    @Deprecated
    @Generated
    public void setTargetUserId(String targetUserId) {
        this.targetUserId = targetUserId;
    }

    @Deprecated
    @Generated
    public void setTargetUserLogin(String targetUserLogin) {
        this.targetUserLogin = targetUserLogin;
    }

    @Deprecated
    @Generated
    public void setFromAutomod(Boolean fromAutomod) {
        this.fromAutomod = fromAutomod;
    }

    @Generated
    public ChatModerationAction() {
    }

    @Generated
    public ChatModerationAction(String type, ModerationAction moderationAction, List<String> args2, String createdBy, String createdByUserId, String msgId, String targetUserId, String targetUserLogin, Boolean fromAutomod) {
        this.type = type;
        this.moderationAction = moderationAction;
        this.args = args2;
        this.createdBy = createdBy;
        this.createdByUserId = createdByUserId;
        this.msgId = msgId;
        this.targetUserId = targetUserId;
        this.targetUserLogin = targetUserLogin;
        this.fromAutomod = fromAutomod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public ModerationType getModType() {
        Object $value = this.modType.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.modType;
            synchronized (atomicReference) {
                $value = this.modType.get();
                if ($value == null) {
                    ModerationType actualValue = ModerationType.parse(this.type, this.moderationAction);
                    $value = actualValue == null ? this.modType : actualValue;
                    this.modType.set($value);
                }
            }
        }
        return (ModerationType)((Object)($value == this.modType ? null : $value));
    }

    public static enum ModerationAction {
        BAN,
        UNBAN,
        TIMEOUT,
        UNTIMEOUT,
        CLEAR,
        DELETE,
        SLOW,
        SLOW_OFF,
        FOLLOWERS,
        FOLLOWERS_OFF,
        R9K_BETA,
        R9K_BETA_OFF,
        EMOTE_ONLY,
        EMOTE_ONLY_OFF,
        SUBSCRIBERS,
        SUBSCRIBERS_OFF,
        VIP,
        UNVIP,
        MOD,
        UNMOD,
        HOST,
        UNHOST,
        RAID,
        UNRAID,
        WARN,
        ACKNOWLEDGE_WARNING,
        AUTOMOD_MESSAGE_REJECTED("automod_message_rejected"),
        AUTOMOD_MESSAGE_APPROVED("automod_message_approved"),
        AUTOMOD_MESSAGE_DENIED("automod_message_denied"),
        AUTOMOD_REJECTED("automod_rejected"),
        APPROVED_AUTOMOD_MESSAGE("approved_automod_message"),
        DENIED_AUTOMOD_MESSAGE("denied_automod_message"),
        ADD_PERMITTED_TERM("add_permitted_term"),
        ADD_BLOCKED_TERM("add_blocked_term"),
        DELETE_PERMITTED_TERM("delete_permitted_term"),
        DELETE_BLOCKED_TERM("delete_blocked_term"),
        MODIFIED_AUTOMOD_PROPERTIES("modified_automod_properties");

        private final String twitchString;
        private static final Map<String, ModerationAction> MAPPINGS;

        private ModerationAction() {
            this.twitchString = this.name().toLowerCase().replace("_", "");
        }

        private ModerationAction(String twitchString) {
            this.twitchString = twitchString;
        }

        @JsonCreator
        public static ModerationAction fromString(String action) {
            return MAPPINGS.get(action);
        }

        @Generated
        public String getTwitchString() {
            return this.twitchString;
        }

        static {
            MAPPINGS = EnumUtil.buildMapping((Enum[])ModerationAction.values(), ModerationAction::getTwitchString);
        }
    }

    public static enum ModerationType {
        CHANNEL,
        LOGIN;


        private static ModerationType parse(String twitchString, ModerationAction modAction) {
            if ("chat_channel_moderation".equals(twitchString)) {
                return CHANNEL;
            }
            if ("chat_login_moderation".equals(twitchString) || "chat_targeted_login_moderation".equals(twitchString)) {
                return LOGIN;
            }
            if (modAction == ModerationAction.MOD || modAction == ModerationAction.UNMOD || modAction == ModerationAction.VIP || modAction == ModerationAction.UNVIP) {
                return LOGIN;
            }
            return null;
        }
    }
}

