/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.domain;

import com.morelaid.streamingmodule.external.jackson.annotation.JsonAlias;
import java.util.OptionalInt;
import lombok.Generated;

public class HypeTrainParticipation {
    private String source;
    private String action;
    @JsonAlias(value={"value"})
    private int quantity;

    public boolean isCheer() {
        return "BITS".equals(this.source);
    }

    public boolean isSub() {
        return "SUBS".equals(this.source);
    }

    public boolean isGifted() {
        return this.action != null && this.action.endsWith("GIFTED_SUB");
    }

    public OptionalInt getSubTier() {
        if (this.action == null || !this.isSub()) {
            return OptionalInt.empty();
        }
        int tier = this.action.charAt("TIER_".length()) - 48;
        return OptionalInt.of(tier);
    }

    @Generated
    public HypeTrainParticipation() {
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public int getQuantity() {
        return this.quantity;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HypeTrainParticipation)) {
            return false;
        }
        HypeTrainParticipation other = (HypeTrainParticipation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQuantity() != other.getQuantity()) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HypeTrainParticipation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQuantity();
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HypeTrainParticipation(source=" + this.getSource() + ", action=" + this.getAction() + ", quantity=" + this.getQuantity() + ")";
    }

    @Generated
    private void setSource(String source2) {
        this.source = source2;
    }

    @Generated
    private void setAction(String action) {
        this.action = action;
    }

    @JsonAlias(value={"value"})
    @Generated
    private void setQuantity(int quantity) {
        this.quantity = quantity;
    }
}

