/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.jackson.databind.JsonNode;
import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.AutomaticRewardRedemption;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.ChannelPointsRedemption;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.ChannelPointsReward;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.CommunityGoalContribution;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.RedemptionProgress;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.AutomaticRewardRedeemedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.CommunityGoalContributionEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.CustomRewardCreatedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.CustomRewardDeletedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.CustomRewardUpdatedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.RedemptionStatusUpdateEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.RewardRedeemedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.UpdateRedemptionFinishedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.UpdateRedemptionProgressEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;

class ChannelPointsHandler
implements TopicHandler {
    ChannelPointsHandler() {
    }

    @Override
    public String topicName() {
        return "channel-points-channel-v1";
    }

    @Override
    public Collection<String> topicNames() {
        return Arrays.asList(this.topicName(), "community-points-channel-v1");
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        JsonNode msgData = args2.getData();
        String timestampText = msgData.path("timestamp").asText();
        Instant instant = Instant.parse(timestampText);
        switch (args2.getType()) {
            case "automatic-reward-redeemed": {
                AutomaticRewardRedemption autoRedemption = TypeConvert.convertValue((Object)msgData.path("redemption"), AutomaticRewardRedemption.class);
                return new AutomaticRewardRedeemedEvent(instant, autoRedemption);
            }
            case "reward-redeemed": {
                ChannelPointsRedemption redemption = TypeConvert.convertValue((Object)msgData.path("redemption"), ChannelPointsRedemption.class);
                return new RewardRedeemedEvent(instant, redemption);
            }
            case "redemption-status-update": {
                ChannelPointsRedemption updatedRedemption = TypeConvert.convertValue((Object)msgData.path("redemption"), ChannelPointsRedemption.class);
                return new RedemptionStatusUpdateEvent(instant, updatedRedemption);
            }
            case "custom-reward-created": {
                ChannelPointsReward newReward = TypeConvert.convertValue((Object)msgData.path("new_reward"), ChannelPointsReward.class);
                return new CustomRewardCreatedEvent(instant, newReward);
            }
            case "custom-reward-updated": {
                ChannelPointsReward updatedReward = TypeConvert.convertValue((Object)msgData.path("updated_reward"), ChannelPointsReward.class);
                return new CustomRewardUpdatedEvent(instant, updatedReward);
            }
            case "custom-reward-deleted": {
                ChannelPointsReward deletedReward = TypeConvert.convertValue((Object)msgData.path("deleted_reward"), ChannelPointsReward.class);
                return new CustomRewardDeletedEvent(instant, deletedReward);
            }
            case "update-redemption-statuses-progress": {
                RedemptionProgress redemptionProgress = TypeConvert.convertValue((Object)msgData.path("progress"), RedemptionProgress.class);
                return new UpdateRedemptionProgressEvent(instant, redemptionProgress);
            }
            case "update-redemption-statuses-finished": {
                RedemptionProgress redemptionFinished = TypeConvert.convertValue((Object)msgData.path("progress"), RedemptionProgress.class);
                return new UpdateRedemptionFinishedEvent(instant, redemptionFinished);
            }
            case "community-goal-contribution": {
                CommunityGoalContribution contribution = TypeConvert.convertValue((Object)msgData.path("contribution"), CommunityGoalContribution.class);
                return new CommunityGoalContributionEvent(instant, contribution);
            }
        }
        return null;
    }
}

