/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.CharityCampaignStatus;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.CharityDonationData;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.CharityCampaignDonationEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.CharityCampaignStatusEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;

class CharityHandler
implements TopicHandler {
    CharityHandler() {
    }

    @Override
    public String topicName() {
        return "charity-campaign-donation-events-v1";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        switch (args2.getType()) {
            case "charity_campaign_donation": {
                CharityDonationData donation = TypeConvert.jsonToObject(args2.getRawMessage(), CharityDonationData.class);
                return new CharityCampaignDonationEvent(args2.getLastTopicPart(), donation);
            }
            case "charity_campaign_status": {
                CharityCampaignStatus status = TypeConvert.jsonToObject(args2.getRawMessage(), CharityCampaignStatus.class);
                return new CharityCampaignStatusEvent(args2.getLastTopicPart(), status);
            }
        }
        return null;
    }
}

