/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.jackson.databind.JsonNode;
import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.AliasRestrictionUpdateData;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.UserModerationActionData;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.AliasRestrictionUpdateEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.UserModerationActionEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;

class ChatroomHandler
implements TopicHandler {
    ChatroomHandler() {
    }

    @Override
    public String topicName() {
        return "chatrooms-user-v1";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        String[] topicParts = args2.getTopicParts();
        if (topicParts.length <= 1) {
            return null;
        }
        String userId = topicParts[1];
        JsonNode msgData = args2.getData();
        switch (args2.getType()) {
            case "channel_banned_alias_restriction_update": {
                AliasRestrictionUpdateData aliasData = TypeConvert.convertValue((Object)msgData, AliasRestrictionUpdateData.class);
                return new AliasRestrictionUpdateEvent(userId, aliasData);
            }
            case "user_moderation_action": {
                UserModerationActionData actionData = TypeConvert.convertValue((Object)msgData, UserModerationActionData.class);
                return new UserModerationActionEvent(userId, actionData);
            }
        }
        return null;
    }
}

