/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.jackson.databind.JsonNode;
import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.DeletePinnedChatData;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.PinnedChatData;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.UpdatedPinnedChatTiming;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.PinnedChatCreatedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.PinnedChatDeletedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.PinnedChatTimingUpdatedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;

class PinHandler
implements TopicHandler {
    PinHandler() {
    }

    @Override
    public String topicName() {
        return "pinned-chat-updates-v1";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        JsonNode msgData = args2.getData();
        switch (args2.getType()) {
            case "pin-message": {
                PinnedChatData createdPin = TypeConvert.convertValue((Object)msgData, PinnedChatData.class);
                return new PinnedChatCreatedEvent(args2.getLastTopicPart(), createdPin);
            }
            case "update-message": {
                UpdatedPinnedChatTiming updatedPin = TypeConvert.convertValue((Object)msgData, UpdatedPinnedChatTiming.class);
                return new PinnedChatTimingUpdatedEvent(args2.getLastTopicPart(), updatedPin);
            }
            case "unpin-message": {
                DeletePinnedChatData deletePin = TypeConvert.convertValue((Object)msgData, DeletePinnedChatData.class);
                return new PinnedChatDeletedEvent(args2.getLastTopicPart(), deletePin);
            }
        }
        return null;
    }
}

