/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.jackson.core.type.TypeReference;
import com.morelaid.streamingmodule.external.jackson.databind.JsonNode;
import com.morelaid.streamingmodule.external.twitch4j.common.enums.CommandPermission;
import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.events.domain.EventUser;
import com.morelaid.streamingmodule.external.twitch4j.common.events.user.PrivateMessageEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TwitchUtils;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.WhisperThread;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.WhisperThreadUpdateEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class WhispersHandler
implements TopicHandler {
    WhispersHandler() {
    }

    @Override
    public String topicName() {
        return "whispers";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        JsonNode msgDataParsed = TypeConvert.jsonToObject(args2.getData().asText(), JsonNode.class);
        String type = args2.getType();
        if ("whisper_sent".equals(type) || "whisper_received".equals(type)) {
            Map<String, Object> tags = TypeConvert.convertValue((Object)msgDataParsed.path("tags"), new TypeReference<Map<String, Object>>(){});
            String fromId = msgDataParsed.get("from_id").asText();
            String displayName = (String)tags.get("display_name");
            EventUser eventUser = new EventUser(fromId, displayName);
            String body = msgDataParsed.get("body").asText();
            Set<CommandPermission> permissions = TwitchUtils.getPermissionsFromTags(tags, new HashMap<String, String>(), fromId, args2.getBotOwnerIds());
            return new PrivateMessageEvent(eventUser, body, permissions);
        }
        if ("thread".equals(type)) {
            WhisperThread thread2 = TypeConvert.convertValue((Object)msgDataParsed, WhisperThread.class);
            return new WhisperThreadUpdateEvent(args2.getLastTopicPart(), thread2);
        }
        return null;
    }
}

