/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.tmi;

import com.morelaid.streamingmodule.external.jackson.databind.ObjectMapper;
import com.morelaid.streamingmodule.external.twitch4j.common.exception.NotFoundException;
import com.morelaid.streamingmodule.external.twitch4j.common.exception.UnauthorizedException;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.tmi.domain.TMIError;
import feign.Request;
import feign.Response;
import feign.RetryableException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class TwitchMessagingInterfaceErrorDecoder
implements ErrorDecoder {
    final Decoder decoder;
    final ErrorDecoder defaultDecoder = new ErrorDecoder.Default();
    final ObjectMapper objectMapper = TypeConvert.getObjectMapper();

    public TwitchMessagingInterfaceErrorDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Exception decode(String methodKey, Response response) {
        try (InputStream is = response.body() == null ? null : response.body().asInputStream();){
            String responseBody;
            String string = responseBody = is == null ? "" : IOUtils.toString(is, StandardCharsets.UTF_8);
            if (response.status() == 401) {
                throw new UnauthorizedException().addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody);
            }
            if (response.status() == 404) {
                throw new NotFoundException().addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody);
            }
            if (response.status() == 503) {
                RetryableException retryableException = new RetryableException(response.status(), "getting service unavailable, retrying ...", Request.HttpMethod.GET, (Long)null, response.request());
                return retryableException;
            }
            TMIError error = this.objectMapper.readValue(responseBody, TMIError.class);
            ContextedRuntimeException contextedRuntimeException = new ContextedRuntimeException("TMI API Error").addContextValue("requestUrl", response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", responseBody).addContextValue("errorType", error.getError()).addContextValue("errorStatus", error.getStatus()).addContextValue("errorType", error.getMessage()).addContextValue("errorMessage", error.getMessage());
            return contextedRuntimeException;
        }
        catch (IOException fallbackToDefault) {
            return this.defaultDecoder.decode(methodKey, response);
        }
    }
}

