/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;

public final class PaginationUtil {
    public static <T, K, C extends Collection<T>, P> C getPaginated(Function<P, K> callByCursor, Function<K, Collection<T>> getResult, Function<K, P> getNext, int maxPages, int maxUnits, Supplier<C> collector, boolean strict, P first, Predicate<P> valid) {
        K call;
        P next;
        Collection collection = (Collection)collector.get();
        HashSet<P> cursors = strict ? new HashSet<P>(Math.max(16, Math.min(maxPages, 1024))) : null;
        P cursor = first;
        int page = 0;
        do {
            Collection<T> results;
            call = callByCursor.apply(cursor);
            ++page;
            if (call == null || (results = getResult.apply(call)) == null || results.isEmpty()) break;
            collection.addAll(results);
        } while (!(Objects.equals(next = getNext.apply(call), cursor) || strict && next != null && !cursors.add(next) || (cursor = next) == null || !valid.test(cursor) || maxPages >= 0 && page >= maxPages) && (maxUnits < 0 || collection.size() < maxUnits));
        return (C)collection;
    }

    public static <T, K, C extends Collection<T>> C getPaginated(Function<String, K> callByCursor, Function<K, Collection<T>> extractResult, Function<K, String> extractCursor, int maxPages, int maxElements, Supplier<C> createCollection, boolean strict) {
        return PaginationUtil.getPaginated(callByCursor, extractResult, extractCursor, maxPages, maxElements, createCollection, strict, null, s2 -> !s2.isEmpty());
    }

    public static <T, K, C extends Collection<T>> C getPaginated(Function<String, K> callByCursor, Function<K, Collection<T>> resultsFromCall, Function<K, String> nextCursorFromCall, int maxPages, int maxElements, Supplier<C> createCollection) {
        return PaginationUtil.getPaginated(callByCursor, resultsFromCall, nextCursorFromCall, maxPages, maxElements, createCollection, false);
    }

    public static <T, K> List<T> getPaginated(Function<String, K> callByCursor, Function<K, Collection<T>> resultsFromCall, Function<K, String> nextCursorFromCall, int maxPages, int maxElements) {
        return PaginationUtil.getPaginated(callByCursor, resultsFromCall, nextCursorFromCall, maxPages, maxElements, ArrayList::new);
    }

    public static <T, K> List<T> getPaginated(Function<String, K> callByCursor, Function<K, Collection<T>> resultsFromCall, Function<K, String> nextCursorFromCall, int maxPages) {
        return PaginationUtil.getPaginated(callByCursor, resultsFromCall, nextCursorFromCall, maxPages, Integer.MAX_VALUE);
    }

    public static <T, K> List<T> getPaginated(Function<String, K> callByCursor, Function<K, Collection<T>> resultsFromCall, Function<K, String> nextCursorFromCall) {
        return PaginationUtil.getPaginated(callByCursor, resultsFromCall, nextCursorFromCall, Integer.MAX_VALUE);
    }

    @Generated
    private PaginationUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

