/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.protocol.x;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.mysql.cj.exceptions.CJCommunicationsException;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.protocol.FullReadInputStream;
import com.mysql.cj.protocol.MessageListener;
import com.mysql.cj.protocol.MessageReader;
import com.mysql.cj.protocol.Protocol;
import com.mysql.cj.protocol.x.MessageConstants;
import com.mysql.cj.protocol.x.Notice;
import com.mysql.cj.protocol.x.XMessage;
import com.mysql.cj.protocol.x.XMessageHeader;
import com.mysql.cj.protocol.x.XProtocolError;
import com.mysql.cj.x.protobuf.Mysqlx;
import com.mysql.cj.x.protobuf.MysqlxNotice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SyncMessageReader
implements MessageReader<XMessageHeader, XMessage> {
    private FullReadInputStream inputStream;
    LinkedList<XMessageHeader> headersQueue = new LinkedList();
    LinkedList<Message> messagesQueue = new LinkedList();
    BlockingQueue<MessageListener<XMessage>> messageListenerQueue = new LinkedBlockingQueue<MessageListener<XMessage>>();
    final Lock dispatchingThreadLock = new ReentrantLock();
    final Lock syncOperationLock = new ReentrantLock();
    Thread dispatchingThread = null;
    private Protocol.ProtocolEventHandler protocolEventHandler = null;

    public SyncMessageReader(FullReadInputStream inputStream2, Protocol.ProtocolEventHandler protocolEventHandler) {
        this.inputStream = inputStream2;
        this.protocolEventHandler = protocolEventHandler;
    }

    @Override
    public XMessageHeader readHeader() throws IOException {
        this.syncOperationLock.lock();
        try {
            XMessageHeader header = this.headersQueue.peek();
            if (header == null) {
                header = this.readHeaderLocal();
            }
            if (header.getMessageType() == 1) {
                throw new XProtocolError(this.readMessageLocal(Mysqlx.Error.class, true));
            }
            XMessageHeader xMessageHeader = header;
            return xMessageHeader;
        }
        finally {
            this.syncOperationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextNonNoticeMessageType() throws IOException {
        this.syncOperationLock.lock();
        try {
            XMessageHeader header;
            if (!this.headersQueue.isEmpty()) {
                for (XMessageHeader hdr : this.headersQueue) {
                    if (hdr.getMessageType() == 11) continue;
                    int n = hdr.getMessageType();
                    return n;
                }
            }
            do {
                if ((header = this.readHeaderLocal()).getMessageType() == 1) {
                    Mysqlx.Error msg = this.readMessageLocal(Mysqlx.Error.class, false);
                    this.messagesQueue.addLast(msg);
                    throw new XProtocolError(msg);
                }
                if (header.getMessageType() != 11) continue;
                this.messagesQueue.addLast(this.readMessageLocal(MysqlxNotice.Frame.class, false));
            } while (header.getMessageType() == 11);
            int n = header.getMessageType();
            return n;
        }
        finally {
            this.syncOperationLock.unlock();
        }
    }

    private XMessageHeader readHeaderLocal() throws IOException {
        XMessageHeader header;
        try {
            byte[] buf = new byte[5];
            this.inputStream.readFully(buf);
            header = new XMessageHeader(buf);
            this.headersQueue.add(header);
        }
        catch (IOException ex) {
            throw new CJCommunicationsException("Cannot read packet header", ex);
        }
        return header;
    }

    private <T extends Message> T readMessageLocal(Class<T> messageClass, boolean fromQueue) {
        XMessageHeader header;
        if (fromQueue) {
            header = this.headersQueue.poll();
            Message msg = this.messagesQueue.poll();
            if (msg != null) {
                return (T)msg;
            }
        } else {
            header = this.headersQueue.getLast();
        }
        Parser<? extends Message> parser = MessageConstants.MESSAGE_CLASS_TO_PARSER.get(messageClass);
        byte[] packet = new byte[header.getMessageSize()];
        try {
            this.inputStream.readFully(packet);
        }
        catch (IOException ex) {
            throw new CJCommunicationsException("Cannot read packet payload", ex);
        }
        try {
            Notice.XWarning w;
            int code;
            Message msg = parser.parseFrom(packet);
            if (msg instanceof MysqlxNotice.Frame && ((MysqlxNotice.Frame)msg).getType() == 1 && ((MysqlxNotice.Frame)msg).getScope() == MysqlxNotice.Frame.Scope.GLOBAL && ((code = (int)(w = new Notice.XWarning((MysqlxNotice.Frame)msg)).getCode()) == 1053 || code == 1810 || code == 3169)) {
                CJCommunicationsException ex = new CJCommunicationsException(w.getMessage());
                ex.setVendorCode(code);
                if (this.protocolEventHandler != null) {
                    this.protocolEventHandler.invokeListeners(code == 1053 ? Protocol.ProtocolEventListener.EventType.SERVER_SHUTDOWN : Protocol.ProtocolEventListener.EventType.SERVER_CLOSED_SESSION, ex);
                }
                throw ex;
            }
            return (T)msg;
        }
        catch (InvalidProtocolBufferException ex) {
            throw new WrongArgumentException(ex);
        }
    }

    @Override
    public XMessage readMessage(Optional<XMessage> reuse, XMessageHeader hdr) throws IOException {
        return this.readMessage((Optional)reuse, hdr.getMessageType());
    }

    @Override
    public XMessage readMessage(Optional<XMessage> reuse, int expectedType) throws IOException {
        this.syncOperationLock.lock();
        try {
            XMessageHeader hdr;
            Class<? extends Message> expectedClass = MessageConstants.getMessageClassForType(expectedType);
            ArrayList<Notice> notices = null;
            while ((hdr = this.readHeader()).getMessageType() == 11 && expectedType != 11) {
                if (notices == null) {
                    notices = new ArrayList<Notice>();
                }
                notices.add(Notice.getInstance(new XMessage(this.readMessageLocal(MessageConstants.getMessageClassForType(11), true))));
            }
            Class<? extends Message> messageClass = MessageConstants.getMessageClassForType(hdr.getMessageType());
            if (expectedClass != messageClass) {
                throw new WrongArgumentException("Unexpected message class. Expected '" + expectedClass.getSimpleName() + "' but actually received '" + messageClass.getSimpleName() + "'");
            }
            XMessage xMessage = new XMessage(this.readMessageLocal(messageClass, true)).addNotices(notices);
            return xMessage;
        }
        catch (IOException e) {
            throw new XProtocolError(e.getMessage(), e);
        }
        finally {
            this.syncOperationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushMessageListener(MessageListener<XMessage> listener) {
        block8: {
            try {
                this.messageListenerQueue.put(listener);
            }
            catch (InterruptedException e) {
                throw new CJCommunicationsException("Cannot queue message listener.", e);
            }
            this.dispatchingThreadLock.lock();
            try {
                if (this.dispatchingThread != null) break block8;
                ListenersDispatcher ld = new ListenersDispatcher();
                this.dispatchingThread = new Thread((Runnable)ld, "Message listeners dispatching thread");
                this.dispatchingThread.start();
                int millis = 5000;
                while (!ld.started) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new XProtocolError(e.getMessage(), e);
                    }
                    if ((millis -= 10) > 0) continue;
                    throw new XProtocolError("Timeout for starting ListenersDispatcher exceeded.");
                }
            }
            finally {
                this.dispatchingThreadLock.unlock();
            }
        }
    }

    private class ListenersDispatcher
    implements Runnable {
        private static final long POLL_TIMEOUT = 100L;
        boolean started = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            SyncMessageReader.this.syncOperationLock.lock();
            try {
                this.started = true;
                try {
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        if ((l = SyncMessageReader.this.messageListenerQueue.poll(100L, TimeUnit.MILLISECONDS)) == null) {
                            SyncMessageReader.this.dispatchingThreadLock.lock();
                            try {
                                if (SyncMessageReader.this.messageListenerQueue.peek() != null) ** GOTO lbl-1000
                                SyncMessageReader.this.dispatchingThread = null;
                                return;
                            }
                            finally {
                                SyncMessageReader.this.dispatchingThreadLock.unlock();
                            }
                            continue;
                        }
                        try {
                            msg = null;
                            while (!l.processMessage(msg = SyncMessageReader.this.readMessage((Optional<XMessage>)null, hdr = SyncMessageReader.this.readHeader()))) {
                            }
                        }
                        catch (Throwable t) {
                            l.error(t);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    throw new CJCommunicationsException("Read operation interrupted.", e);
                }
                ** GOTO lbl-1000
            }
            finally {
                SyncMessageReader.this.syncOperationLock.unlock();
            }
        }
    }
}

