/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class DynamicListProperty<T> {
    private volatile List<T> values;
    private final DynamicStringProperty delegate;
    private final String delimiter;
    public static final String DEFAULT_DELIMITER = ",";

    public DynamicListProperty(String string, String string2) {
        this(string, string2, DEFAULT_DELIMITER);
    }

    public DynamicListProperty(String string, String string2, String string3) {
        this.delegate = DynamicPropertyFactory.getInstance().getStringProperty(string, string2);
        this.delimiter = string3;
        this.load();
        this.delegate.addCallback(new Runnable(){

            @Override
            public void run() {
                DynamicListProperty.this.propertyChangedInternal();
            }
        });
    }

    public DynamicListProperty(String string, List<T> list) {
        this(string, list, DEFAULT_DELIMITER);
    }

    public DynamicListProperty(String string, List<T> list, String string2) {
        this(string, (String)null, string2);
        if (this.values == null && list != null) {
            this.values = Collections.unmodifiableList(list);
        }
    }

    private void propertyChangedInternal() {
        this.load();
        this.propertyChanged();
    }

    protected void propertyChanged() {
    }

    public List<T> get() {
        return this.values;
    }

    protected void load() {
        if (this.delegate.get() == null) {
            return;
        }
        List<String> list = Arrays.asList(this.delegate.get().split(this.delimiter));
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (String string : list) {
            arrayList.add(this.from(string));
        }
        this.values = Collections.unmodifiableList(arrayList);
    }

    public long getChangedTimestamp() {
        return this.delegate.getChangedTimestamp();
    }

    public void addCallback(Runnable runnable2) {
        if (runnable2 != null) {
            this.delegate.addCallback(runnable2);
        }
    }

    protected abstract T from(String var1);
}

