/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.AbstractPollingScheduler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class FixedDelayPollingScheduler
extends AbstractPollingScheduler {
    private ScheduledExecutorService executor;
    private int initialDelayMillis = 30000;
    private int delayMillis = 60000;
    public static final String INITIAL_DELAY_PROPERTY = "archaius.fixedDelayPollingScheduler.initialDelayMills";
    public static final String DELAY_PROPERTY = "archaius.fixedDelayPollingScheduler.delayMills";

    public FixedDelayPollingScheduler() {
        String string;
        String string2 = System.getProperty(INITIAL_DELAY_PROPERTY);
        if (string2 != null && string2.length() > 0) {
            this.initialDelayMillis = Integer.parseInt(string2);
        }
        if ((string = System.getProperty(DELAY_PROPERTY)) != null && string.length() > 0) {
            this.delayMillis = Integer.parseInt(string);
        }
    }

    public FixedDelayPollingScheduler(int n, int n2, boolean bl) {
        super(bl);
        this.initialDelayMillis = n;
        this.delayMillis = n2;
    }

    @Override
    protected synchronized void schedule(Runnable runnable2) {
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable2) {
                Thread thread2 = new Thread(runnable2, "pollingConfigurationSource");
                thread2.setDaemon(true);
                return thread2;
            }
        });
        this.executor.scheduleWithFixedDelay(runnable2, this.initialDelayMillis, this.delayMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

