/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.ExecutionResult;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixMetrics;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.metric.HystrixCommandCompletion;
import com.netflix.hystrix.metric.consumer.CumulativeThreadPoolEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingThreadPoolEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingThreadPoolMaxConcurrencyStream;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import rx.functions.Func0;
import rx.functions.Func2;

public class HystrixThreadPoolMetrics
extends HystrixMetrics {
    private static final HystrixEventType[] ALL_COMMAND_EVENT_TYPES = HystrixEventType.values();
    private static final HystrixEventType.ThreadPool[] ALL_THREADPOOL_EVENT_TYPES = HystrixEventType.ThreadPool.values();
    private static final int NUMBER_THREADPOOL_EVENT_TYPES = ALL_THREADPOOL_EVENT_TYPES.length;
    private static final ConcurrentHashMap<String, HystrixThreadPoolMetrics> metrics = new ConcurrentHashMap();
    public static final Func2<long[], HystrixCommandCompletion, long[]> appendEventToBucket = new Func2<long[], HystrixCommandCompletion, long[]>(){

        @Override
        public long[] call(long[] initialCountArray, HystrixCommandCompletion execution) {
            ExecutionResult.EventCounts eventCounts = execution.getEventCounts();
            for (HystrixEventType eventType : ALL_COMMAND_EVENT_TYPES) {
                long eventCount = eventCounts.getCount(eventType);
                HystrixEventType.ThreadPool threadPoolEventType = HystrixEventType.ThreadPool.from(eventType);
                if (threadPoolEventType == null) continue;
                int n = threadPoolEventType.ordinal();
                initialCountArray[n] = initialCountArray[n] + eventCount;
            }
            return initialCountArray;
        }
    };
    public static final Func2<long[], long[], long[]> counterAggregator = new Func2<long[], long[], long[]>(){

        @Override
        public long[] call(long[] cumulativeEvents, long[] bucketEventCounts) {
            for (int i = 0; i < NUMBER_THREADPOOL_EVENT_TYPES; ++i) {
                int n = i;
                cumulativeEvents[n] = cumulativeEvents[n] + bucketEventCounts[i];
            }
            return cumulativeEvents;
        }
    };
    private final HystrixThreadPoolKey threadPoolKey;
    private final ThreadPoolExecutor threadPool;
    private final HystrixThreadPoolProperties properties;
    private final AtomicInteger concurrentExecutionCount = new AtomicInteger();
    private final RollingThreadPoolEventCounterStream rollingCounterStream;
    private final CumulativeThreadPoolEventCounterStream cumulativeCounterStream;
    private final RollingThreadPoolMaxConcurrencyStream rollingThreadPoolMaxConcurrencyStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HystrixThreadPoolMetrics getInstance(HystrixThreadPoolKey key, ThreadPoolExecutor threadPool, HystrixThreadPoolProperties properties) {
        HystrixThreadPoolMetrics threadPoolMetrics = metrics.get(key.name());
        if (threadPoolMetrics != null) {
            return threadPoolMetrics;
        }
        Class<HystrixThreadPoolMetrics> clazz = HystrixThreadPoolMetrics.class;
        synchronized (HystrixThreadPoolMetrics.class) {
            HystrixThreadPoolMetrics existingMetrics = metrics.get(key.name());
            if (existingMetrics != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return existingMetrics;
            }
            HystrixThreadPoolMetrics newThreadPoolMetrics = new HystrixThreadPoolMetrics(key, threadPool, properties);
            metrics.putIfAbsent(key.name(), newThreadPoolMetrics);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return newThreadPoolMetrics;
        }
    }

    public static HystrixThreadPoolMetrics getInstance(HystrixThreadPoolKey key) {
        return metrics.get(key.name());
    }

    public static Collection<HystrixThreadPoolMetrics> getInstances() {
        ArrayList<HystrixThreadPoolMetrics> threadPoolMetrics = new ArrayList<HystrixThreadPoolMetrics>();
        for (HystrixThreadPoolMetrics tpm : metrics.values()) {
            if (!HystrixThreadPoolMetrics.hasExecutedCommandsOnThread(tpm)) continue;
            threadPoolMetrics.add(tpm);
        }
        return Collections.unmodifiableCollection(threadPoolMetrics);
    }

    private static boolean hasExecutedCommandsOnThread(HystrixThreadPoolMetrics threadPoolMetrics) {
        return threadPoolMetrics.getCurrentCompletedTaskCount().intValue() > 0;
    }

    static void reset() {
        metrics.clear();
    }

    private HystrixThreadPoolMetrics(HystrixThreadPoolKey threadPoolKey, ThreadPoolExecutor threadPool, HystrixThreadPoolProperties properties) {
        super(null);
        this.threadPoolKey = threadPoolKey;
        this.threadPool = threadPool;
        this.properties = properties;
        this.rollingCounterStream = RollingThreadPoolEventCounterStream.getInstance(threadPoolKey, properties);
        this.cumulativeCounterStream = CumulativeThreadPoolEventCounterStream.getInstance(threadPoolKey, properties);
        this.rollingThreadPoolMaxConcurrencyStream = RollingThreadPoolMaxConcurrencyStream.getInstance(threadPoolKey, properties);
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    public HystrixThreadPoolProperties getProperties() {
        return this.properties;
    }

    public Number getCurrentActiveCount() {
        return this.threadPool.getActiveCount();
    }

    public Number getCurrentCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    public Number getCurrentCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    public Number getCurrentLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    public Number getCurrentMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public Number getCurrentPoolSize() {
        return this.threadPool.getPoolSize();
    }

    public Number getCurrentTaskCount() {
        return this.threadPool.getTaskCount();
    }

    public Number getCurrentQueueSize() {
        return this.threadPool.getQueue().size();
    }

    public void markThreadExecution() {
        this.concurrentExecutionCount.incrementAndGet();
    }

    public long getRollingCountThreadsExecuted() {
        return this.rollingCounterStream.getLatestCount(HystrixEventType.ThreadPool.EXECUTED);
    }

    public long getCumulativeCountThreadsExecuted() {
        return this.cumulativeCounterStream.getLatestCount(HystrixEventType.ThreadPool.EXECUTED);
    }

    public long getRollingCountThreadsRejected() {
        return this.rollingCounterStream.getLatestCount(HystrixEventType.ThreadPool.REJECTED);
    }

    public long getCumulativeCountThreadsRejected() {
        return this.cumulativeCounterStream.getLatestCount(HystrixEventType.ThreadPool.REJECTED);
    }

    public long getRollingCount(HystrixEventType.ThreadPool event) {
        return this.rollingCounterStream.getLatestCount(event);
    }

    public long getCumulativeCount(HystrixEventType.ThreadPool event) {
        return this.cumulativeCounterStream.getLatestCount(event);
    }

    @Override
    public long getCumulativeCount(HystrixRollingNumberEvent event) {
        return this.cumulativeCounterStream.getLatestCount(HystrixEventType.ThreadPool.from(event));
    }

    @Override
    public long getRollingCount(HystrixRollingNumberEvent event) {
        return this.rollingCounterStream.getLatestCount(HystrixEventType.ThreadPool.from(event));
    }

    public void markThreadCompletion() {
        this.concurrentExecutionCount.decrementAndGet();
    }

    public long getRollingMaxActiveThreads() {
        return this.rollingThreadPoolMaxConcurrencyStream.getLatestRollingMax();
    }

    public void markThreadRejection() {
        this.concurrentExecutionCount.decrementAndGet();
    }

    public static Func0<Integer> getCurrentConcurrencyThunk(final HystrixThreadPoolKey threadPoolKey) {
        return new Func0<Integer>(){

            @Override
            public Integer call() {
                return HystrixThreadPoolMetrics.getInstance(threadPoolKey).concurrentExecutionCount.get();
            }
        };
    }
}

