/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.collapser;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.collapser.CollapserTimer;
import com.netflix.hystrix.collapser.HystrixCollapserBridge;
import com.netflix.hystrix.collapser.RequestCollapser;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableHolder;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import com.netflix.hystrix.util.HystrixTimer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCollapserFactory<BatchReturnType, ResponseType, RequestArgumentType> {
    private static final Logger logger = LoggerFactory.getLogger(RequestCollapserFactory.class);
    private final CollapserTimer timer;
    private final HystrixCollapserKey collapserKey;
    private final HystrixCollapserProperties properties;
    private final HystrixConcurrencyStrategy concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
    private final Scope scope;
    private static ConcurrentHashMap<String, RequestCollapser<?, ?, ?>> globalScopedCollapsers = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>>> requestScopedCollapsers = new ConcurrentHashMap();

    public RequestCollapserFactory(HystrixCollapserKey collapserKey, Scope scope, CollapserTimer timer, HystrixCollapserProperties.Setter propertiesBuilder) {
        this(collapserKey, scope, timer, HystrixPropertiesFactory.getCollapserProperties(collapserKey, propertiesBuilder));
    }

    public RequestCollapserFactory(HystrixCollapserKey collapserKey, Scope scope, CollapserTimer timer, HystrixCollapserProperties properties) {
        this.timer = timer;
        this.scope = scope;
        this.collapserKey = collapserKey;
        this.properties = properties;
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.collapserKey;
    }

    public Scope getScope() {
        return this.scope;
    }

    public HystrixCollapserProperties getProperties() {
        return this.properties;
    }

    public RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> getRequestCollapser(HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser) {
        if (Scopes.REQUEST == Scopes.valueOf(this.getScope().name())) {
            return this.getCollapserForUserRequest(commandCollapser);
        }
        if (Scopes.GLOBAL == Scopes.valueOf(this.getScope().name())) {
            return this.getCollapserForGlobalScope(commandCollapser);
        }
        logger.warn("Invalid Scope: {}  Defaulting to REQUEST scope.", (Object)this.getScope());
        return this.getCollapserForUserRequest(commandCollapser);
    }

    private RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> getCollapserForGlobalScope(HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser) {
        RequestCollapser<?, ?, ?> collapser = globalScopedCollapsers.get(this.collapserKey.name());
        if (collapser != null) {
            return collapser;
        }
        RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> newCollapser = new RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType>(commandCollapser, this.properties, this.timer, this.concurrencyStrategy);
        RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> existing = globalScopedCollapsers.putIfAbsent(this.collapserKey.name(), newCollapser);
        if (existing == null) {
            return newCollapser;
        }
        newCollapser.shutdown();
        return existing;
    }

    private RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> getCollapserForUserRequest(HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser) {
        return this.getRequestVariableForCommand(commandCollapser).get(this.concurrencyStrategy);
    }

    private HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>> getRequestVariableForCommand(HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser) {
        HystrixRequestVariableHolder requestVariable = requestScopedCollapsers.get(commandCollapser.getCollapserKey().name());
        if (requestVariable == null) {
            RequestCollapserRequestVariable newCollapser = new RequestCollapserRequestVariable(commandCollapser, this.properties, this.timer, this.concurrencyStrategy);
            HystrixRequestVariableHolder existing = requestScopedCollapsers.putIfAbsent(commandCollapser.getCollapserKey().name(), newCollapser);
            requestVariable = existing == null ? newCollapser : existing;
        }
        return requestVariable;
    }

    public static void reset() {
        globalScopedCollapsers.clear();
        requestScopedCollapsers.clear();
        HystrixTimer.reset();
    }

    public static void resetRequest() {
        requestScopedCollapsers.clear();
    }

    public static HystrixRequestVariableHolder<RequestCollapser<?, ?, ?>> getRequestVariable(String key) {
        return requestScopedCollapsers.get(key);
    }

    private final class RequestCollapserRequestVariable
    extends HystrixRequestVariableHolder<RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType>> {
        private RequestCollapserRequestVariable(final HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser, final HystrixCollapserProperties properties, final CollapserTimer timer, final HystrixConcurrencyStrategy concurrencyStrategy) {
            super(new HystrixRequestVariableLifecycle<RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType>>(){

                @Override
                public RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> initialValue() {
                    return new RequestCollapser(commandCollapser, properties, timer, concurrencyStrategy);
                }

                @Override
                public void shutdown(RequestCollapser<BatchReturnType, ResponseType, RequestArgumentType> currentCollapser) {
                    if (currentCollapser != null) {
                        currentCollapser.shutdown();
                    }
                }
            });
        }
    }

    private static enum Scopes implements Scope
    {
        REQUEST,
        GLOBAL;

    }

    public static interface Scope {
        public String name();
    }
}

