/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.concurrency.HystrixLifecycleForwardingRequestVariable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import com.netflix.hystrix.util.PlatformSpecific;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HystrixConcurrencyStrategy {
    private static final Logger logger = LoggerFactory.getLogger(HystrixConcurrencyStrategy.class);

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixProperty<Integer> corePoolSize, HystrixProperty<Integer> maximumPoolSize, HystrixProperty<Integer> keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        int dynamicMaximumSize;
        ThreadFactory threadFactory = HystrixConcurrencyStrategy.getThreadFactory(threadPoolKey);
        int dynamicCoreSize = corePoolSize.get();
        if (dynamicCoreSize > (dynamicMaximumSize = maximumPoolSize.get().intValue())) {
            logger.error("Hystrix ThreadPool configuration at startup for : " + threadPoolKey.name() + " is trying to set coreSize = " + dynamicCoreSize + " and maximumSize = " + dynamicMaximumSize + ".  Maximum size will be set to " + dynamicCoreSize + ", the coreSize value, since it must be equal to or greater than the coreSize value");
            return new ThreadPoolExecutor(dynamicCoreSize, dynamicCoreSize, (long)keepAliveTime.get().intValue(), unit, workQueue, threadFactory);
        }
        return new ThreadPoolExecutor(dynamicCoreSize, dynamicMaximumSize, (long)keepAliveTime.get().intValue(), unit, workQueue, threadFactory);
    }

    public ThreadPoolExecutor getThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties threadPoolProperties) {
        ThreadFactory threadFactory = HystrixConcurrencyStrategy.getThreadFactory(threadPoolKey);
        boolean allowMaximumSizeToDivergeFromCoreSize = threadPoolProperties.getAllowMaximumSizeToDivergeFromCoreSize().get();
        int dynamicCoreSize = threadPoolProperties.coreSize().get();
        int keepAliveTime = threadPoolProperties.keepAliveTimeMinutes().get();
        int maxQueueSize = threadPoolProperties.maxQueueSize().get();
        BlockingQueue<Runnable> workQueue = this.getBlockingQueue(maxQueueSize);
        if (allowMaximumSizeToDivergeFromCoreSize) {
            int dynamicMaximumSize = threadPoolProperties.maximumSize().get();
            if (dynamicCoreSize > dynamicMaximumSize) {
                logger.error("Hystrix ThreadPool configuration at startup for : " + threadPoolKey.name() + " is trying to set coreSize = " + dynamicCoreSize + " and maximumSize = " + dynamicMaximumSize + ".  Maximum size will be set to " + dynamicCoreSize + ", the coreSize value, since it must be equal to or greater than the coreSize value");
                return new ThreadPoolExecutor(dynamicCoreSize, dynamicCoreSize, (long)keepAliveTime, TimeUnit.MINUTES, workQueue, threadFactory);
            }
            return new ThreadPoolExecutor(dynamicCoreSize, dynamicMaximumSize, (long)keepAliveTime, TimeUnit.MINUTES, workQueue, threadFactory);
        }
        return new ThreadPoolExecutor(dynamicCoreSize, dynamicCoreSize, (long)keepAliveTime, TimeUnit.MINUTES, workQueue, threadFactory);
    }

    private static ThreadFactory getThreadFactory(final HystrixThreadPoolKey threadPoolKey) {
        if (!PlatformSpecific.isAppEngineStandardEnvironment()) {
            return new ThreadFactory(){
                private final AtomicInteger threadNumber = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread2 = new Thread(r, "hystrix-" + threadPoolKey.name() + "-" + this.threadNumber.incrementAndGet());
                    thread2.setDaemon(true);
                    return thread2;
                }
            };
        }
        return PlatformSpecific.getAppEngineThreadFactory();
    }

    public BlockingQueue<Runnable> getBlockingQueue(int maxQueueSize) {
        if (maxQueueSize <= 0) {
            return new SynchronousQueue<Runnable>();
        }
        return new LinkedBlockingQueue<Runnable>(maxQueueSize);
    }

    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        return callable;
    }

    public <T> HystrixRequestVariable<T> getRequestVariable(HystrixRequestVariableLifecycle<T> rv) {
        return new HystrixLifecycleForwardingRequestVariable<T>(rv);
    }
}

