/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AsyncClient;
import feign.AsyncResponseHandler;
import feign.ExceptionPropagationPolicy;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.MethodHandlerConfiguration;
import feign.MethodInfo;
import feign.MethodInfoResolver;
import feign.MethodMetadata;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.RequestTemplateFactoryResolver;
import feign.Response;
import feign.RetryableException;
import feign.Retryer;
import feign.Target;
import feign.Util;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

final class AsynchronousMethodHandler<C>
implements InvocationHandlerFactory.MethodHandler {
    private final AsyncClient<C> client;
    private final C requestContext;
    private final AsyncResponseHandler asyncResponseHandler;
    private final MethodInfo methodInfo;
    private final MethodHandlerConfiguration methodHandlerConfiguration;

    private AsynchronousMethodHandler(MethodHandlerConfiguration methodHandlerConfiguration, AsyncClient<C> client, AsyncResponseHandler asyncResponseHandler, C requestContext, MethodInfo methodInfo) {
        this.methodHandlerConfiguration = Util.checkNotNull(methodHandlerConfiguration, "methodHandlerConfiguration", new Object[0]);
        this.client = Util.checkNotNull(client, "client for %s", methodHandlerConfiguration.getTarget());
        this.requestContext = requestContext;
        this.asyncResponseHandler = asyncResponseHandler;
        this.methodInfo = methodInfo;
    }

    @Override
    public Object invoke(Object[] argv) throws Throwable {
        RequestTemplate template = this.methodHandlerConfiguration.getBuildTemplateFromArgs().create(argv);
        Request.Options options = this.findOptions(argv);
        Retryer retryer = this.methodHandlerConfiguration.getRetryer().clone();
        try {
            if (this.methodInfo.isAsyncReturnType()) {
                return this.executeAndDecode(template, options, retryer);
            }
            return this.executeAndDecode(template, options, retryer).join();
        }
        catch (CompletionException e) {
            throw e.getCause();
        }
    }

    private CompletableFuture<Object> executeAndDecode(RequestTemplate template, Request.Options options, Retryer retryer) {
        CancellableFuture<Object> resultFuture = new CancellableFuture<Object>();
        this.executeAndDecode(template, options).whenComplete((response, throwable) -> {
            if (throwable != null) {
                if (!resultFuture.isDone() && this.shouldRetry(retryer, (Throwable)throwable, (CompletableFuture<Object>)resultFuture)) {
                    if (this.methodHandlerConfiguration.getLogLevel() != Logger.Level.NONE) {
                        this.methodHandlerConfiguration.getLogger().logRetry(this.methodHandlerConfiguration.getMetadata().configKey(), this.methodHandlerConfiguration.getLogLevel());
                    }
                    resultFuture.setInner(this.executeAndDecode(template, options, retryer));
                }
            } else {
                resultFuture.complete(response);
            }
        });
        return resultFuture;
    }

    private boolean shouldRetry(Retryer retryer, Throwable throwable, CompletableFuture<Object> resultFuture) {
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (!(throwable instanceof RetryableException)) {
            resultFuture.completeExceptionally(throwable);
            return false;
        }
        RetryableException retryableException = (RetryableException)throwable;
        try {
            retryer.continueOrPropagate(retryableException);
            return true;
        }
        catch (RetryableException th) {
            Throwable cause = th.getCause();
            if (this.methodHandlerConfiguration.getPropagationPolicy() == ExceptionPropagationPolicy.UNWRAP && cause != null) {
                resultFuture.completeExceptionally(cause);
            } else {
                resultFuture.completeExceptionally(th);
            }
            return false;
        }
    }

    private CompletableFuture<Object> executeAndDecode(RequestTemplate template, Request.Options options) {
        Request request = this.targetRequest(template);
        if (this.methodHandlerConfiguration.getLogLevel() != Logger.Level.NONE) {
            this.methodHandlerConfiguration.getLogger().logRequest(this.methodHandlerConfiguration.getMetadata().configKey(), this.methodHandlerConfiguration.getLogLevel(), request);
        }
        long start2 = System.nanoTime();
        return ((CompletableFuture)((CompletableFuture)this.client.execute(request, options, Optional.ofNullable(this.requestContext)).thenApply(response -> AsynchronousMethodHandler.ensureRequestIsSet(response, template, request))).exceptionally(throwable -> {
            CompletionException completionException;
            CompletionException completionException2 = completionException = throwable instanceof CompletionException ? (CompletionException)throwable : new CompletionException((Throwable)throwable);
            if (completionException.getCause() instanceof IOException) {
                IOException ioException = (IOException)completionException.getCause();
                if (this.methodHandlerConfiguration.getLogLevel() != Logger.Level.NONE) {
                    this.methodHandlerConfiguration.getLogger().logIOException(this.methodHandlerConfiguration.getMetadata().configKey(), this.methodHandlerConfiguration.getLogLevel(), ioException, this.elapsedTime(start2));
                }
                throw FeignException.errorExecuting(request, ioException);
            }
            throw completionException;
        })).thenCompose(response -> this.handleResponse((Response)response, this.elapsedTime(start2)));
    }

    private static Response ensureRequestIsSet(Response response, RequestTemplate template, Request request) {
        return response.toBuilder().request(request).requestTemplate(template).build();
    }

    private CompletableFuture<Object> handleResponse(Response response, long elapsedTime) {
        return this.asyncResponseHandler.handleResponse(this.methodHandlerConfiguration.getMetadata().configKey(), response, this.methodInfo.underlyingReturnType(), elapsedTime);
    }

    private long elapsedTime(long start2) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2);
    }

    private Request targetRequest(RequestTemplate template) {
        for (RequestInterceptor interceptor : this.methodHandlerConfiguration.getRequestInterceptors()) {
            interceptor.apply(template);
        }
        return this.methodHandlerConfiguration.getTarget().apply(template);
    }

    private Request.Options findOptions(Object[] argv) {
        if (argv == null || argv.length == 0) {
            return this.methodHandlerConfiguration.getOptions();
        }
        return Stream.of(argv).filter(Request.Options.class::isInstance).map(Request.Options.class::cast).findFirst().orElse(this.methodHandlerConfiguration.getOptions());
    }

    static class Factory<C>
    implements InvocationHandlerFactory.MethodHandler.Factory<C> {
        private final AsyncClient<C> client;
        private final Retryer retryer;
        private final List<RequestInterceptor> requestInterceptors;
        private final AsyncResponseHandler responseHandler;
        private final Logger logger;
        private final Logger.Level logLevel;
        private final ExceptionPropagationPolicy propagationPolicy;
        private final MethodInfoResolver methodInfoResolver;
        private final RequestTemplateFactoryResolver requestTemplateFactoryResolver;
        private final Request.Options options;

        Factory(AsyncClient<C> client, Retryer retryer, List<RequestInterceptor> requestInterceptors, AsyncResponseHandler responseHandler, Logger logger, Logger.Level logLevel, ExceptionPropagationPolicy propagationPolicy, MethodInfoResolver methodInfoResolver, RequestTemplateFactoryResolver requestTemplateFactoryResolver, Request.Options options) {
            this.client = Util.checkNotNull(client, "client", new Object[0]);
            this.retryer = Util.checkNotNull(retryer, "retryer", new Object[0]);
            this.requestInterceptors = Util.checkNotNull(requestInterceptors, "requestInterceptors", new Object[0]);
            this.responseHandler = responseHandler;
            this.logger = Util.checkNotNull(logger, "logger", new Object[0]);
            this.logLevel = Util.checkNotNull(logLevel, "logLevel", new Object[0]);
            this.propagationPolicy = propagationPolicy;
            this.methodInfoResolver = methodInfoResolver;
            this.requestTemplateFactoryResolver = Util.checkNotNull(requestTemplateFactoryResolver, "requestTemplateFactoryResolver", new Object[0]);
            this.options = Util.checkNotNull(options, "options", new Object[0]);
        }

        @Override
        public InvocationHandlerFactory.MethodHandler create(Target<?> target, MethodMetadata metadata, C requestContext) {
            RequestTemplate.Factory buildTemplateFromArgs = this.requestTemplateFactoryResolver.resolve(target, metadata);
            MethodHandlerConfiguration methodHandlerConfiguration = new MethodHandlerConfiguration(metadata, target, this.retryer, this.requestInterceptors, this.logger, this.logLevel, buildTemplateFromArgs, this.options, this.propagationPolicy);
            return new AsynchronousMethodHandler(methodHandlerConfiguration, this.client, this.responseHandler, requestContext, this.methodInfoResolver.resolve(target.type(), metadata.method()));
        }
    }

    private static class CancellableFuture<T>
    extends CompletableFuture<T> {
        private CompletableFuture<T> inner = null;

        private CancellableFuture() {
        }

        public void setInner(CompletableFuture<T> value) {
            this.inner = value;
            this.inner.whenComplete((BiConsumer)CancellableFuture.pipeTo(this));
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = super.cancel(mayInterruptIfRunning);
            if (this.inner != null) {
                this.inner.cancel(mayInterruptIfRunning);
            }
            return result;
        }

        private static <T> BiConsumer<? super T, ? super Throwable> pipeTo(CompletableFuture<T> completableFuture) {
            return (value, throwable) -> {
                if (completableFuture.isDone()) {
                    return;
                }
                if (throwable != null) {
                    completableFuture.completeExceptionally((Throwable)throwable);
                } else {
                    completableFuture.complete(value);
                }
            };
        }
    }
}

