/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Client;
import feign.ExceptionPropagationPolicy;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.MethodHandlerConfiguration;
import feign.MethodMetadata;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.RequestTemplateFactoryResolver;
import feign.Response;
import feign.ResponseHandler;
import feign.RetryableException;
import feign.Retryer;
import feign.Target;
import feign.Util;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

final class SynchronousMethodHandler
implements InvocationHandlerFactory.MethodHandler {
    private final Client client;
    private final ResponseHandler responseHandler;
    private final MethodHandlerConfiguration methodHandlerConfiguration;

    private SynchronousMethodHandler(MethodHandlerConfiguration methodHandlerConfiguration, Client client, ResponseHandler responseHandler) {
        this.methodHandlerConfiguration = Util.checkNotNull(methodHandlerConfiguration, "methodHandlerConfiguration", new Object[0]);
        this.client = Util.checkNotNull(client, "client for %s", methodHandlerConfiguration.getTarget());
        this.responseHandler = responseHandler;
    }

    @Override
    public Object invoke(Object[] argv) throws Throwable {
        RequestTemplate template = this.methodHandlerConfiguration.getBuildTemplateFromArgs().create(argv);
        Request.Options options = this.findOptions(argv);
        Retryer retryer = this.methodHandlerConfiguration.getRetryer().clone();
        while (true) {
            try {
                return this.executeAndDecode(template, options);
            }
            catch (RetryableException e) {
                try {
                    retryer.continueOrPropagate(e);
                }
                catch (RetryableException th) {
                    Throwable cause = th.getCause();
                    if (this.methodHandlerConfiguration.getPropagationPolicy() == ExceptionPropagationPolicy.UNWRAP && cause != null) {
                        throw cause;
                    }
                    throw th;
                }
                if (this.methodHandlerConfiguration.getLogLevel() == Logger.Level.NONE) continue;
                this.methodHandlerConfiguration.getLogger().logRetry(this.methodHandlerConfiguration.getMetadata().configKey(), this.methodHandlerConfiguration.getLogLevel());
                continue;
            }
            break;
        }
    }

    Object executeAndDecode(RequestTemplate template, Request.Options options) throws Throwable {
        Response response;
        Request request = this.targetRequest(template);
        if (this.methodHandlerConfiguration.getLogLevel() != Logger.Level.NONE) {
            this.methodHandlerConfiguration.getLogger().logRequest(this.methodHandlerConfiguration.getMetadata().configKey(), this.methodHandlerConfiguration.getLogLevel(), request);
        }
        long start2 = System.nanoTime();
        try {
            response = this.client.execute(request, options);
            response = response.toBuilder().request(request).requestTemplate(template).build();
        }
        catch (IOException e) {
            if (this.methodHandlerConfiguration.getLogLevel() != Logger.Level.NONE) {
                this.methodHandlerConfiguration.getLogger().logIOException(this.methodHandlerConfiguration.getMetadata().configKey(), this.methodHandlerConfiguration.getLogLevel(), e, this.elapsedTime(start2));
            }
            throw FeignException.errorExecuting(request, e);
        }
        long elapsedTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2);
        return this.responseHandler.handleResponse(this.methodHandlerConfiguration.getMetadata().configKey(), response, this.methodHandlerConfiguration.getMetadata().returnType(), elapsedTime);
    }

    long elapsedTime(long start2) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2);
    }

    Request targetRequest(RequestTemplate template) {
        for (RequestInterceptor interceptor : this.methodHandlerConfiguration.getRequestInterceptors()) {
            interceptor.apply(template);
        }
        return this.methodHandlerConfiguration.getTarget().apply(template);
    }

    Request.Options findOptions(Object[] argv) {
        if (argv == null || argv.length == 0) {
            return this.methodHandlerConfiguration.getOptions().getMethodOptions(this.methodHandlerConfiguration.getMetadata().method().getName());
        }
        return Stream.of(argv).filter(Request.Options.class::isInstance).map(Request.Options.class::cast).findFirst().orElse(this.methodHandlerConfiguration.getOptions().getMethodOptions(this.methodHandlerConfiguration.getMetadata().method().getName()));
    }

    static class Factory
    implements InvocationHandlerFactory.MethodHandler.Factory<Object> {
        private final Client client;
        private final Retryer retryer;
        private final List<RequestInterceptor> requestInterceptors;
        private final ResponseHandler responseHandler;
        private final Logger logger;
        private final Logger.Level logLevel;
        private final ExceptionPropagationPolicy propagationPolicy;
        private final RequestTemplateFactoryResolver requestTemplateFactoryResolver;
        private final Request.Options options;

        Factory(Client client, Retryer retryer, List<RequestInterceptor> requestInterceptors, ResponseHandler responseHandler, Logger logger, Logger.Level logLevel, ExceptionPropagationPolicy propagationPolicy, RequestTemplateFactoryResolver requestTemplateFactoryResolver, Request.Options options) {
            this.client = Util.checkNotNull(client, "client", new Object[0]);
            this.retryer = Util.checkNotNull(retryer, "retryer", new Object[0]);
            this.requestInterceptors = Util.checkNotNull(requestInterceptors, "requestInterceptors", new Object[0]);
            this.responseHandler = Util.checkNotNull(responseHandler, "responseHandler", new Object[0]);
            this.logger = Util.checkNotNull(logger, "logger", new Object[0]);
            this.logLevel = Util.checkNotNull(logLevel, "logLevel", new Object[0]);
            this.propagationPolicy = propagationPolicy;
            this.requestTemplateFactoryResolver = Util.checkNotNull(requestTemplateFactoryResolver, "requestTemplateFactoryResolver", new Object[0]);
            this.options = Util.checkNotNull(options, "options", new Object[0]);
        }

        @Override
        public InvocationHandlerFactory.MethodHandler create(Target<?> target, MethodMetadata md, Object requestContext) {
            RequestTemplate.Factory buildTemplateFromArgs = this.requestTemplateFactoryResolver.resolve(target, md);
            MethodHandlerConfiguration methodHandlerConfiguration = new MethodHandlerConfiguration(md, target, this.retryer, this.requestInterceptors, this.logger, this.logLevel, buildTemplateFromArgs, this.options, this.propagationPolicy);
            return new SynchronousMethodHandler(methodHandlerConfiguration, this.client, this.responseHandler);
        }
    }
}

