/*
 * Decompiled with CFR 0.152.
 */
package feign.jackson;

import com.morelaid.streamingmodule.external.jackson.annotation.JsonInclude;
import com.morelaid.streamingmodule.external.jackson.core.JsonProcessingException;
import com.morelaid.streamingmodule.external.jackson.databind.JavaType;
import com.morelaid.streamingmodule.external.jackson.databind.Module;
import com.morelaid.streamingmodule.external.jackson.databind.ObjectMapper;
import com.morelaid.streamingmodule.external.jackson.databind.SerializationFeature;
import feign.RequestTemplate;
import feign.Util;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.lang.reflect.Type;
import java.util.Collections;

public class JacksonEncoder
implements Encoder {
    private final ObjectMapper mapper;

    public JacksonEncoder() {
        this(Collections.emptyList());
    }

    public JacksonEncoder(Iterable<Module> modules) {
        this(new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(SerializationFeature.INDENT_OUTPUT, true).registerModules(modules));
    }

    public JacksonEncoder(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void encode(Object object, Type bodyType, RequestTemplate template) {
        try {
            JavaType javaType = this.mapper.getTypeFactory().constructType(bodyType);
            template.body(this.mapper.writerFor(javaType).writeValueAsBytes(object), Util.UTF_8);
        }
        catch (JsonProcessingException e) {
            throw new EncodeException(e.getMessage(), e);
        }
    }
}

