/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Timeout {
    public static final Timeout NO_TIMEOUT = Timeout.notSpecifiedTimeout();

    public <T> T call(Function<Optional<Long>, T> var1);

    public void run(Consumer<Optional<Long>> var1);

    public <T> CompletableFuture<T> callAsync(Function<Optional<Long>, CompletableFuture<T>> var1);

    public static Timeout of(ClientSideConfig clientSideConfig) {
        Optional<Long> requestTimeout = clientSideConfig.getRequestTimeoutNanos();
        if (!requestTimeout.isPresent()) {
            return NO_TIMEOUT;
        }
        TimeMeter clientClock = clientSideConfig.getClientSideClock().orElse(TimeMeter.SYSTEM_NANOTIME);
        return Timeout.boundedTimeout(clientClock, requestTimeout.get());
    }

    public static Timeout notSpecifiedTimeout() {
        return new Timeout(){

            @Override
            public <T> T call(Function<Optional<Long>, T> timeBoundedOperation) {
                return timeBoundedOperation.apply(Optional.empty());
            }

            @Override
            public void run(Consumer<Optional<Long>> timeBoundedOperation) {
                timeBoundedOperation.accept(Optional.empty());
            }

            @Override
            public <T> CompletableFuture<T> callAsync(Function<Optional<Long>, CompletableFuture<T>> timeBoundedOperation) {
                return timeBoundedOperation.apply(Optional.empty());
            }
        };
    }

    public static Timeout boundedTimeout(final TimeMeter clientClock, final long requestTimeoutNanos) {
        final long startNanos = clientClock.currentTimeNanos();
        return new Timeout(){

            @Override
            public <T> T call(Function<Optional<Long>, T> timeBoundedOperation) {
                long nanosElapsed = clientClock.currentTimeNanos() - startNanos;
                if (nanosElapsed >= requestTimeoutNanos) {
                    throw BucketExceptions.timeoutReached(nanosElapsed, requestTimeoutNanos);
                }
                long remainingLimitNanos = requestTimeoutNanos - nanosElapsed;
                return timeBoundedOperation.apply(Optional.of(remainingLimitNanos));
            }

            @Override
            public <T> CompletableFuture<T> callAsync(Function<Optional<Long>, CompletableFuture<T>> timeBoundedOperation) {
                long nanosElapsed = clientClock.currentTimeNanos() - startNanos;
                if (nanosElapsed >= requestTimeoutNanos) {
                    CompletableFuture timeouted = new CompletableFuture();
                    timeouted.completeExceptionally(BucketExceptions.timeoutReached(nanosElapsed, requestTimeoutNanos));
                    return timeouted;
                }
                long remainingLimitNanos = requestTimeoutNanos - nanosElapsed;
                return timeBoundedOperation.apply(Optional.of(remainingLimitNanos));
            }

            @Override
            public void run(Consumer<Optional<Long>> timeBoundedOperation) {
                long nanosElapsed = clientClock.currentTimeNanos() - startNanos;
                if (nanosElapsed >= requestTimeoutNanos) {
                    throw BucketExceptions.timeoutReached(nanosElapsed, requestTimeoutNanos);
                }
                long remainingLimitNanos = requestTimeoutNanos - nanosElapsed;
                timeBoundedOperation.accept(Optional.of(remainingLimitNanos));
            }
        };
    }
}

