/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.generic.compare_and_swap;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.Timeout;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractCompareAndSwapBasedProxyManager<K>
extends AbstractProxyManager<K> {
    private static final CommandResult<?> UNSUCCESSFUL_CAS_RESULT = null;

    protected AbstractCompareAndSwapBasedProxyManager(ClientSideConfig clientSideConfig) {
        super(AbstractCompareAndSwapBasedProxyManager.injectTimeClock(clientSideConfig));
    }

    @Override
    public <T> CommandResult<T> execute(K key, Request<T> request) {
        CommandResult<T> result;
        Timeout timeout2 = Timeout.of(this.getClientSideConfig());
        CompareAndSwapOperation operation = timeout2.call(requestTimeout -> this.beginCompareAndSwapOperation(key));
        while ((result = this.execute(request, operation, timeout2)) == UNSUCCESSFUL_CAS_RESULT) {
        }
        return result;
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        Timeout timeout2 = Timeout.of(this.getClientSideConfig());
        AsyncCompareAndSwapOperation operation = this.beginAsyncCompareAndSwapOperation(key);
        CompletableFuture<CommandResult<T>> result = this.executeAsync(request, operation, timeout2);
        return result.thenCompose(response -> this.retryIfCasWasUnsuccessful(operation, request, (CommandResult)response, timeout2));
    }

    protected abstract CompareAndSwapOperation beginCompareAndSwapOperation(K var1);

    protected abstract AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(K var1);

    private <T> CommandResult<T> execute(Request<T> request, CompareAndSwapOperation operation, Timeout timeout2) {
        RemoteCommand<T> command = request.getCommand();
        byte[] originalStateBytes = timeout2.call(operation::getStateData).orElse(null);
        MutableBucketEntry entry = new MutableBucketEntry(originalStateBytes);
        CommandResult<T> result = command.execute(entry, this.getClientSideTime());
        if (!entry.isStateModified()) {
            return result;
        }
        byte[] newStateBytes = entry.getStateBytes(request.getBackwardCompatibilityVersion());
        if (timeout2.call(requestTimeout -> operation.compareAndSwap(originalStateBytes, newStateBytes, entry.get(), (Optional<Long>)requestTimeout)).booleanValue()) {
            return result;
        }
        return null;
    }

    private <T> CompletableFuture<CommandResult<T>> retryIfCasWasUnsuccessful(AsyncCompareAndSwapOperation operation, Request<T> request, CommandResult<T> casResponse, Timeout timeout2) {
        if (casResponse != UNSUCCESSFUL_CAS_RESULT) {
            return CompletableFuture.completedFuture(casResponse);
        }
        return this.executeAsync(request, operation, timeout2).thenCompose(response -> this.retryIfCasWasUnsuccessful(operation, request, (CommandResult)response, timeout2));
    }

    private <T> CompletableFuture<CommandResult<T>> executeAsync(Request<T> request, AsyncCompareAndSwapOperation operation, Timeout timeout2) {
        return ((CompletableFuture)timeout2.callAsync(operation::getStateData).thenApply(originalStateBytes -> originalStateBytes.orElse(null))).thenCompose(originalStateBytes -> {
            RemoteCommand command = request.getCommand();
            MutableBucketEntry entry = new MutableBucketEntry((byte[])originalStateBytes);
            CommandResult result = command.execute(entry, this.getClientSideTime());
            if (!entry.isStateModified()) {
                return CompletableFuture.completedFuture(result);
            }
            byte[] newStateBytes = entry.getStateBytes(request.getBackwardCompatibilityVersion());
            return timeout2.callAsync(requestTimeout -> operation.compareAndSwap((byte[])originalStateBytes, newStateBytes, entry.get(), (Optional<Long>)requestTimeout)).thenApply(casWasSuccessful -> casWasSuccessful != false ? result : null);
        });
    }

    private static ClientSideConfig injectTimeClock(ClientSideConfig clientSideConfig) {
        if (clientSideConfig.getClientSideClock().isPresent()) {
            return clientSideConfig;
        }
        return clientSideConfig.withClientClock(TimeMeter.SYSTEM_MILLISECONDS);
    }
}

